/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.i18n;

import com.atlassian.confluence.util.i18n.I18NResource;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.plugin.PluginAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;

public abstract class AbstractI18NResource
implements I18NResource {
    public static final Category log = Category.getInstance(AbstractI18NResource.class);
    protected PluginAccessor pluginAccessor;

    protected AbstractI18NResource(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public ResourceBundle getBundle() {
        String resourcePath = this.getResourcePath(null);
        if (resourcePath != null) {
            return this.loadBundle(resourcePath);
        }
        return null;
    }

    public ResourceBundle getBundle(String localeString) {
        String resourcePath = this.getResourcePath(localeString);
        if (resourcePath != null) {
            return this.loadBundle(resourcePath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle loadBundle(String resourcePath) {
        InputStream is;
        block6: {
            PropertyResourceBundle propertyResourceBundle;
            is = null;
            try {
                if (this.pluginAccessor == null) {
                    log.error((Object)"Plugin manager is null");
                }
                if ((is = this.pluginAccessor.getDynamicResourceAsStream(resourcePath)) == null) {
                    is = ClassLoaderUtils.getResourceAsStream((String)resourcePath, this.getClass());
                }
                if (is == null) break block6;
                propertyResourceBundle = new PropertyResourceBundle(is);
            }
            catch (IOException e) {
                try {
                    log.error((Object)("Error loading resource " + resourcePath), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
            return propertyResourceBundle;
        }
        IOUtils.closeQuietly((InputStream)is);
        return null;
    }

    protected abstract String getResourcePath(String var1);
}

