/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.i18n;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CacheManagerKeys;
import com.atlassian.confluence.event.events.admin.ConfluenceReadyEvent;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import java.util.Locale;
import org.apache.log4j.Category;

public class CachingI18NBeanFactory
implements I18NBeanFactory,
EventListener {
    public static final Category log = Category.getInstance(CachingI18NBeanFactory.class);
    private CacheFactory cacheFactory;
    private I18NBeanFactory defaultI18NBeanFactory;
    private boolean disableCache = Boolean.getBoolean("confluence.i18n.reloadbundles");

    public I18NBean getI18NBean(Locale locale) {
        I18NBean cachedI18NBean = (I18NBean)this.getCacheByLocale().get((Object)locale);
        if (cachedI18NBean == null) {
            cachedI18NBean = this.defaultI18NBeanFactory.getI18NBean(locale);
            if (!this.disableCache) {
                this.getCacheByLocale().put((Object)locale, (Object)cachedI18NBean);
            }
        }
        return cachedI18NBean;
    }

    public I18NBean getI18NBean() {
        return this.getI18NBean(LocaleManager.DEFAULT_LOCALE);
    }

    private Cache getCacheByLocale() {
        return this.cacheFactory.getCache(CacheManagerKeys.CACHE_I18NBEAN_BY_LOCALE);
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public void setDefaultI18NBeanFactory(I18NBeanFactory defaultI18NBeanFactory) {
        this.defaultI18NBeanFactory = defaultI18NBeanFactory;
    }

    public void handleEvent(Event event) {
        try {
            this.getCacheByLocale().removeAll();
        }
        catch (Exception e) {
            log.error((Object)"Error clearing cache.", (Throwable)e);
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{GlobalSettingsChangedEvent.class, PluginEvent.class, ConfluenceReadyEvent.class};
    }
}

