/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.i18n;

import com.atlassian.confluence.util.i18n.CombinedResourceBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ResourceBundlesCollector {
    private TreeMap bundleListsByLocale = new TreeMap(new ReverseComparator());

    public void addBundle(ResourceBundle bundle) {
        ArrayList<ResourceBundle> bundlesList = (ArrayList<ResourceBundle>)this.bundleListsByLocale.get("<NOLOCALE>");
        if (bundlesList == null) {
            bundlesList = new ArrayList<ResourceBundle>();
            this.bundleListsByLocale.put("<NOLOCALE>", bundlesList);
        }
        bundlesList.add(bundle);
    }

    public void addBundles(Map bundlesByLocale) {
        for (String locale : bundlesByLocale.keySet()) {
            ResourceBundle bundle = (ResourceBundle)bundlesByLocale.get(locale);
            ArrayList<ResourceBundle> bundlesList = (ArrayList<ResourceBundle>)this.bundleListsByLocale.get(locale);
            if (bundlesList == null) {
                bundlesList = new ArrayList<ResourceBundle>();
                this.bundleListsByLocale.put(locale, bundlesList);
            }
            bundlesList.add(bundle);
        }
    }

    public List getCombinedResourceBundles() {
        ArrayList<CombinedResourceBundle> result = new ArrayList<CombinedResourceBundle>();
        for (List bundlesList : this.bundleListsByLocale.values()) {
            result.add(new CombinedResourceBundle(bundlesList));
        }
        return result;
    }
}

