/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.i18n;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.UserLocaleAware;
import com.atlassian.user.User;
import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class UserI18NBeanFactory
implements I18NBeanFactory,
BeanPostProcessor {
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;

    public I18NBean getI18NBean(Locale locale) {
        return this.i18NBeanFactory.getI18NBean(locale);
    }

    public I18NBean getI18NBean() {
        return this.getI18NBean(this.getUserLocale());
    }

    private Locale getUserLocale() {
        return this.localeManager.getLocale(this.getRemoteUser());
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    private User getRemoteUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof UserLocaleAware) {
            ((UserLocaleAware)bean).setI18NBeanFactory(this);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

