/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.longrunning;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.WebDavAttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.AttachmentManagerConfiguration;
import com.atlassian.confluence.pages.persistence.dao.SimpleWebDavConfiguration;
import com.atlassian.confluence.pages.persistence.dao.WebDavAttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.WebDavConfiguration;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.spring.container.ContainerManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class AttachmentMigrationLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    protected AttachmentDao.AttachmentMigrator migrator;
    private JohnsonEventContainer johnsonEventContainer;
    private String destinationStore;
    private String webdavUrl;
    private String webdavLogin;
    private String webdavPassword;

    public AttachmentMigrationLongRunningTask(String destinationStore, String webdavUrl, String webdavLogin, String webdavPassword) {
        if (destinationStore == null) {
            throw new IllegalArgumentException("The destination store cannot be null.");
        }
        this.destinationStore = destinationStore;
        this.webdavUrl = webdavUrl;
        this.webdavLogin = webdavLogin;
        this.webdavPassword = webdavPassword;
    }

    public void runInternal() {
        Event johnsonEvent = new Event(JohnsonConfig.getInstance().getEventType("attachment-migration"), "Attachment Data Migration", JohnsonConfig.getInstance().getEventLevel("warning"));
        this.johnsonEventContainer.addEvent(johnsonEvent);
        try {
            SimpleWebDavConfiguration config = null;
            if ("webdav.based.attachments.storage".equals(this.destinationStore)) {
                config = new SimpleWebDavConfiguration(this.webdavUrl, this.webdavLogin, this.webdavPassword);
            }
            AttachmentManager currentAttachmentManager = (AttachmentManager)ContainerManager.getComponent((String)"attachmentManager");
            AttachmentManager destinationAttachmentManager = this.getAttachmentManagerWithConfig(this.destinationStore, config);
            this.migrator = currentAttachmentManager.getMigrator(destinationAttachmentManager);
            this.migrator.setProgressMeter(this.progress);
            TransactionTemplate tt = new TransactionTemplate();
            tt.setTransactionManager((PlatformTransactionManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"transactionManager"));
            tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    AttachmentMigrationLongRunningTask.this.migrator.migrate();
                    SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
                    Settings settings = settingsManager.getGlobalSettings();
                    if ("webdav.based.attachments.storage".equals(AttachmentMigrationLongRunningTask.this.destinationStore)) {
                        settings.setWebdavServerUrl(AttachmentMigrationLongRunningTask.this.webdavUrl);
                        settings.setWebdavUsername(AttachmentMigrationLongRunningTask.this.webdavLogin);
                        settings.setWebdavPassword(AttachmentMigrationLongRunningTask.this.webdavPassword);
                    } else {
                        settings.setWebdavServerUrl(null);
                        settings.setWebdavUsername(null);
                        settings.setWebdavPassword(null);
                    }
                    settings.setAttachmentDataStore(AttachmentMigrationLongRunningTask.this.destinationStore);
                    settings.setWebdavServerUrl(AttachmentMigrationLongRunningTask.this.webdavUrl);
                    settings.setWebdavUsername(AttachmentMigrationLongRunningTask.this.webdavLogin);
                    settings.setWebdavPassword(AttachmentMigrationLongRunningTask.this.webdavPassword);
                    settingsManager.updateGlobalSettings(settings);
                }
            });
        }
        catch (RuntimeException e) {
            this.progress.setStatus("There was an error in the transfer. Please check your log files.");
            this.progress.setCompletedSuccessfully(false);
            throw e;
        }
        finally {
            this.johnsonEventContainer.removeEvent(johnsonEvent);
        }
    }

    private AttachmentManager getAttachmentManagerWithConfig(String type, AttachmentManagerConfiguration config) {
        if (type.equals("webdav.based.attachments.storage")) {
            WebDavAttachmentManager webDavAttachmentManager = new WebDavAttachmentManager();
            ContainerManager.autowireComponent((Object)webDavAttachmentManager);
            WebDavAttachmentDao webDavAttachmentDao = new WebDavAttachmentDao();
            ContainerManager.autowireComponent((Object)webDavAttachmentDao);
            if (!(config instanceof WebDavConfiguration)) {
                throw new IllegalArgumentException("The config parameter must be an instance of WebDavConfiguration for the WebDAV Attachment Manager.");
            }
            webDavAttachmentDao.setConfig((WebDavConfiguration)config);
            webDavAttachmentManager.setAttachmentDao(webDavAttachmentDao);
            return webDavAttachmentManager;
        }
        if (type.equals("database.based.attachments.storage")) {
            return (AttachmentManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"databaseAttachmentManager");
        }
        return (AttachmentManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"defaultAttachmentManager");
    }

    public String getName() {
        return "Attachment data migration";
    }

    public void setJohnsonEventContainer(JohnsonEventContainer johnsonEventContainer) {
        this.johnsonEventContainer = johnsonEventContainer;
    }
}

