/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.message;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.util.message.Message;
import com.atlassian.confluence.util.message.MessageEntry;
import com.atlassian.confluence.util.message.MessageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultMessageManager
implements MessageManager {
    public static final String PERSISTENCE_KEY = "confluence.message.manager";
    private BandanaManager bandanaManager;

    public List getMessages(String spaceKey, String user) {
        Map messages = this.retrieveMessages(null);
        if (spaceKey != null) {
            messages.putAll(this.retrieveMessages(spaceKey));
        }
        ArrayList<Message> result = new ArrayList<Message>();
        for (MessageEntry entry : messages.values()) {
            if (!entry.isApplicable(user)) continue;
            result.add(entry.getMessage());
        }
        return result;
    }

    public List getMessages(String spaceKey) {
        HashMap messages = new HashMap();
        if (spaceKey != null) {
            messages.putAll(this.retrieveMessages(spaceKey));
        }
        ArrayList<Message> result = new ArrayList<Message>();
        for (MessageEntry entry : messages.values()) {
            result.add(entry.getMessage());
        }
        return result;
    }

    public List getMessages() {
        return this.getMessages(null, null);
    }

    private Map retrieveMessages(String spaceKey) {
        HashMap messages = (HashMap)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), PERSISTENCE_KEY);
        if (messages == null) {
            messages = new HashMap();
        }
        return messages;
    }

    private void saveMessages(String spaceKey, Map messages) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), PERSISTENCE_KEY, (Object)messages);
    }

    public void removeMessage(String spaceKey, String id) {
        Map messages = this.retrieveMessages(spaceKey);
        messages.remove(id);
        this.saveMessages(spaceKey, messages);
    }

    public void addMessage(Message message) {
        this.addMessage(null, null, message);
    }

    public void addMessage(String spaceKey, String username, Message message) {
        Map messages = this.retrieveMessages(spaceKey);
        messages.put(message.getId(), new MessageEntry(message, username));
        this.saveMessages(spaceKey, messages);
    }

    public void addMessage(String spaceKey, Message message) {
        this.addMessage(spaceKey, null, message);
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }
}

