/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.misc;

import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.validators.FieldValidatorSupport;
import java.util.regex.Pattern;

public class CssColourValidator
extends FieldValidatorSupport {
    private static final Pattern WORD_MATCH = Pattern.compile("^[a-zA-Z]\\w*$");
    private static final Pattern SHORT_NUMERIC_MATCH = Pattern.compile("^#([\\da-fA-F]){3}$");
    private static final Pattern LONG_NUMERIC_MATCH = Pattern.compile("^#([\\da-fA-F]){6}$");
    private static final Pattern RGB_MATCH = Pattern.compile("^rgb\\((\\d+),\\s*(\\d+),\\s*(\\d+)\\)$");
    private static final Pattern PERC_MATCH = Pattern.compile("^rgb\\((\\d+)%,\\s*(\\d+)%,\\s*(\\d+)%\\)$");

    public void validate(Object object) throws ValidationException {
        String fieldValue = ((String)this.getFieldValue(this.getFieldName(), object)).trim();
        if (!CssColourValidator.check(fieldValue)) {
            this.addFieldError(this.getFieldName(), object);
        }
    }

    public static boolean check(String thingToCheck) {
        if (thingToCheck == null) {
            return true;
        }
        return (thingToCheck = thingToCheck.trim()).length() == 0 || WORD_MATCH.matcher(thingToCheck).matches() || SHORT_NUMERIC_MATCH.matcher(thingToCheck).matches() || LONG_NUMERIC_MATCH.matcher(thingToCheck).matches() || RGB_MATCH.matcher(thingToCheck).matches() || PERC_MATCH.matcher(thingToCheck).matches();
    }
}

