/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.task;

import com.atlassian.core.task.Task;
import com.atlassian.trackback.DefaultTrackbackFinder;
import com.atlassian.trackback.DefaultTrackbackSender;
import com.atlassian.trackback.Trackback;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;

public class TrackbackQueueItem
implements Task {
    private static final Category log = Category.getInstance(TrackbackQueueItem.class);
    private Trackback trackback;
    private Collection urls;

    public TrackbackQueueItem(Trackback trackback, Collection urls) {
        this.trackback = trackback;
        this.urls = urls;
    }

    public void execute() throws Exception {
        DefaultTrackbackSender tbs = new DefaultTrackbackSender();
        DefaultTrackbackFinder finder = new DefaultTrackbackFinder();
        List pingUrls = finder.findPingUrls(this.urls);
        for (String pingUrl : pingUrls) {
            log.debug((Object)("Sending ping to URL " + pingUrl));
            tbs.sendPing(pingUrl, this.trackback);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrackbackQueueItem)) {
            return false;
        }
        TrackbackQueueItem trackbackQueueItem = (TrackbackQueueItem)o;
        if (this.trackback != null ? !this.trackback.equals((Object)trackbackQueueItem.trackback) : trackbackQueueItem.trackback != null) {
            return false;
        }
        return !(this.urls != null ? !((Object)this.urls).equals(trackbackQueueItem.urls) : trackbackQueueItem.urls != null);
    }

    public int hashCode() {
        int result = this.trackback != null ? this.trackback.hashCode() : 0;
        result = 29 * result + (this.urls != null ? ((Object)this.urls).hashCode() : 0);
        return result;
    }
}

