/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.velocity;

import com.atlassian.confluence.util.velocity.ResourceLoaderWrapper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.springframework.util.Assert;

final class Velocity13CompatibleResourceLoader
extends ResourceLoaderWrapper {
    private static final Logger log = Logger.getLogger(Velocity13CompatibleResourceLoader.class);
    private final Charset charset;

    public Velocity13CompatibleResourceLoader(ResourceLoader wrappedLoader, String charsetName) {
        super(wrappedLoader);
        Assert.notNull((Object)charsetName, (String)"charsetName must not be null");
        this.charset = Charset.forName(charsetName);
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        ByteArrayInputStream byteArrayInputStream;
        InputStream resourceStream = super.getResourceStream(name);
        if (resourceStream == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converting velocity resource: " + name));
        }
        InputStreamReader resourceReader = null;
        try {
            resourceReader = new InputStreamReader(resourceStream, this.charset);
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(resourceStream.available());
            OutputStreamWriter conversionWriter = new OutputStreamWriter((OutputStream)byteOutputStream, this.charset);
            new Velocity13TemplateConverter(name, resourceReader).convert(conversionWriter);
            byteArrayInputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("IOException while converting resource", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)resourceReader);
        return byteArrayInputStream;
    }

    private static class Velocity13TemplateConverter {
        private static final Pattern regex = Pattern.compile("(#[a-zA-Z0-9]*\\s*\\()(\\s*)([^'\" !$\\)\\(]{1,})");
        private final Reader resourceReader;
        private final String resourceName;

        private Velocity13TemplateConverter(String resourceName, Reader resourceReader) {
            this.resourceName = resourceName;
            this.resourceReader = resourceReader;
        }

        public void convert(Writer destinationWriter) throws IOException {
            BufferedWriter bufferedWriter = new BufferedWriter(destinationWriter);
            LineIterator lineIterator = IOUtils.lineIterator((Reader)this.resourceReader);
            while (lineIterator.hasNext()) {
                String line = lineIterator.nextLine();
                Matcher matcher = regex.matcher(line);
                if (matcher.find() && !matcher.group(1).startsWith("#macro")) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Found incompatible Velocity 1.5 syntax in resource: " + this.resourceName + "; " + matcher.group()));
                    }
                    bufferedWriter.write(matcher.replaceAll("$1$2\"$3\""));
                } else {
                    bufferedWriter.write(line);
                }
                bufferedWriter.newLine();
            }
            IOUtils.closeQuietly((Writer)bufferedWriter);
        }
    }
}

