/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.velocity.debug;

import com.atlassian.confluence.util.velocity.debug.UberspectDebugDecorator;
import org.apache.log4j.Logger;
import org.apache.velocity.util.introspection.VelMethod;

public class VelMethodDebugDecorator
implements VelMethod {
    private final VelMethod delegate;
    private static final Logger VELOCITY_LOG = UberspectDebugDecorator.VELOCITY_LOG;

    public VelMethodDebugDecorator(VelMethod delegate) {
        this.delegate = delegate;
    }

    public Object invoke(Object o, Object[] params) throws Exception {
        if (VELOCITY_LOG.isDebugEnabled()) {
            VELOCITY_LOG.debug((Object)("invoking method [" + o.getClass().getName() + "#" + this.getMethodName() + "]"));
        }
        return this.delegate.invoke(o, params);
    }

    private String paramsToString(Object[] params) {
        int maxlength = 40;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            Object param;
            String val;
            if (i > 0) {
                buf.append(",");
            }
            if ((val = String.valueOf(param = params[i])).length() > maxlength) {
                val = val.substring(0, maxlength - 3) + "...";
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public boolean isCacheable() {
        return this.delegate.isCacheable();
    }

    public String getMethodName() {
        return this.delegate.getMethodName();
    }

    public Class getReturnType() {
        return this.delegate.getReturnType();
    }
}

