/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util.zip;

import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.confluence.util.zip.FileUnzipper;
import com.atlassian.confluence.util.zip.Unzipper;
import com.atlassian.core.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Category;

public abstract class AbstractUnzipper
implements Unzipper {
    protected static Category log = Category.getInstance(FileUnzipper.class);
    private static final int BUFFER_SIZE = 10240;
    protected File destDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File saveEntry(InputStream is, ZipEntry entry) throws IOException {
        File file = new File(this.destDir, entry.getName());
        if (entry.isDirectory()) {
            file.mkdirs();
            return file;
        }
        File dir = new File(file.getParent());
        dir.mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            FileUtils.copy((InputStream)is, (OutputStream)fos, (int)10240);
            fos.flush();
        }
        catch (FileNotFoundException fnfe) {
            File file2;
            try {
                log.error((Object)("Error extracting a file to '" + this.destDir + File.separator + entry.getName() + "'. This destination is invalid for writing an extracted file stream to. "));
                file2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(fos);
                throw throwable;
            }
            IOUtils.close(fos);
            return file2;
        }
        IOUtils.close(fos);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZipEntry[] entries(ZipInputStream zis) throws IOException {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        try {
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                entries.add(zipEntry);
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
        finally {
            IOUtils.close(zis);
        }
        return entries.toArray(new ZipEntry[entries.size()]);
    }
}

