/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.context;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.velocity.debug.DebugReferenceInsertionEventHandler;
import com.atlassian.confluence.velocity.context.AntiXssSettingBasedCartridgeProcessor;
import com.atlassian.confluence.velocity.context.HtmlSafeVelocityCartridgeProcessor;
import com.atlassian.confluence.velocity.context.NoOpTemplateAwareCartridgeProcessor;
import com.atlassian.confluence.velocity.context.TemplateAwareCartridgeProcessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.context.Context;

public final class ConfluenceContextUtils {
    private static final TemplateAwareCartridgeProcessor CARTRIDGE_PROCESSOR = ConfluenceContextUtils.getEventCartridgeProcessor();

    private static TemplateAwareCartridgeProcessor getEventCartridgeProcessor() {
        HtmlEncodingSystemProperty property = HtmlEncodingSystemProperty.getInstance();
        if (!property.isPresent()) {
            return new AntiXssSettingBasedCartridgeProcessor();
        }
        if (property.isSet()) {
            return new HtmlSafeVelocityCartridgeProcessor();
        }
        return new NoOpTemplateAwareCartridgeProcessor();
    }

    private ConfluenceContextUtils() {
    }

    public static void processContextForTemplate(Template template, Context context) {
        EventCartridge cartridge = new EventCartridge();
        cartridge.addEventHandler((EventHandler)new DebugReferenceInsertionEventHandler());
        CARTRIDGE_PROCESSOR.processCartridge(template, cartridge);
        cartridge.attachToContext(context);
    }

    public static void processContextForHtmlRendering(Context context) {
        EventCartridge cartridge = new EventCartridge();
        cartridge.addEventHandler((EventHandler)new DebugReferenceInsertionEventHandler());
        CARTRIDGE_PROCESSOR.processCartridge(cartridge);
        cartridge.attachToContext(context);
    }

    private static User getUser(String username) {
        if (!ContainerManager.isContainerSetup()) {
            return null;
        }
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        return userAccessor.getUser(username);
    }

    public static void modifyRequestContext(Context context, HttpServletRequest request) {
        context.put("user", (Object)ConfluenceContextUtils.getUser(request.getRemoteUser()));
        if (request.getSession().getAttribute("confluence.user.history") != null) {
            context.put("userHistory", request.getSession().getAttribute("confluence.user.history"));
        }
    }

    private static final class HtmlEncodingSystemProperty {
        private final String PROPERTY = System.getProperty("confluence.html.encode.automatic");

        private HtmlEncodingSystemProperty() {
        }

        public static HtmlEncodingSystemProperty getInstance() {
            return new HtmlEncodingSystemProperty();
        }

        public boolean isPresent() {
            return this.PROPERTY != null;
        }

        public boolean isSet() {
            return Boolean.valueOf(this.PROPERTY);
        }
    }
}

