/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.htmlsafe;

import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.confluence.velocity.introspection.AnnotationBoxedElement;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlSafeAnnotationUtils {
    public static final Annotation HTML_SAFE_ANNOTATION = HtmlSafeAnnotationFactory.getHtmlSafeAnnotation();

    private HtmlSafeAnnotationUtils() {
    }

    public static boolean hasHtmlSafeToStringMethod(Object value) {
        try {
            return value.getClass().getMethod("toString", new Class[0]).isAnnotationPresent(HtmlSafe.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Object does not have a toString method");
        }
    }

    public static boolean isHtmlSafeValue(AnnotationBoxedElement value) {
        return HtmlSafeAnnotationUtils.hasHtmlSafeToStringMethod(value.unbox()) || HtmlSafeAnnotationUtils.containsAnnotationOfType(Arrays.asList(value.getAnnotations()), HtmlSafe.class);
    }

    public static boolean containsAnnotationOfType(Collection<Annotation> annotations, Class<? extends Annotation> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    private static class HtmlSafeAnnotationFactory {
        private HtmlSafeAnnotationFactory() {
        }

        static Annotation getHtmlSafeAnnotation() {
            try {
                return HtmlSafeAnnotationHolder.class.getMethod("holder", new Class[0]).getAnnotation(HtmlSafe.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        private static interface HtmlSafeAnnotationHolder {
            @HtmlSafe
            public Object holder();
        }
    }
}

