/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.htmlsafe;

import com.atlassian.confluence.velocity.htmlsafe.HtmlRegExps;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafeAnnotationUtils;
import com.atlassian.confluence.velocity.introspection.AnnotatedReferenceHandler;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalWrapperContext;
import org.apache.velocity.util.ContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleIncorrectHtmlEncodingEventHandler
extends AnnotatedReferenceHandler
implements ContextAware {
    private static final Logger log = Logger.getLogger(PossibleIncorrectHtmlEncodingEventHandler.class);
    private Context context;

    public static boolean isLoggingEnabled() {
        return log.isEnabledFor(Priority.INFO);
    }

    @Override
    protected Object annotatedValueInsert(String referenceName, Object value, Collection<Annotation> annotations) {
        if (value == null) {
            return value;
        }
        boolean isHtmlSafeValue = HtmlSafeAnnotationUtils.containsAnnotationOfType(annotations, HtmlSafe.class) || HtmlSafeAnnotationUtils.hasHtmlSafeToStringMethod(value);
        String stringValue = value.toString();
        if (!isHtmlSafeValue && (this.hasHtml(stringValue) || this.hasEncodedHtml(stringValue))) {
            log.info((Object)(referenceName + " in " + this.getCurrentTemplateName()));
        }
        return value;
    }

    private boolean hasHtml(String string) {
        return HtmlRegExps.HTML_TAG_PATTERN.matcher(string).find();
    }

    private boolean hasEncodedHtml(String string) {
        return HtmlRegExps.HTML_ENTITY_PATTERN.matcher(string).find();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private String getCurrentTemplateName() {
        String templateName;
        if (this.context instanceof InternalWrapperContext) {
            InternalWrapperContext wrapper = (InternalWrapperContext)this.context;
            templateName = wrapper.getBaseContext().getCurrentTemplateName();
        } else {
            templateName = "unknown";
        }
        return templateName;
    }

    static {
        log.info((Object)"This log records Velocity template references that may have been incorrectly handled by the automatic HTML encoding system");
    }
}

