/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import com.atlassian.confluence.velocity.introspection.AnnotatedValue;
import com.atlassian.confluence.velocity.introspection.AnnotationValidationUtils;
import com.atlassian.confluence.velocity.introspection.BoxedValue;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotatedValueIterator
implements Iterator,
BoxedValue {
    private final Iterator boxedIterator;
    private final Collection<Annotation> annotations;

    public AnnotatedValueIterator(Iterator iterator, Collection<Annotation> annotations) {
        Assert.notNull((Object)iterator, (String)"iterator must not be null");
        Assert.notNull(annotations, (String)"annotations must not be null");
        AnnotationValidationUtils.assertContainsNoNulls(annotations, "annotations must not contain nulls");
        this.boxedIterator = iterator;
        this.annotations = annotations;
    }

    @Override
    public boolean hasNext() {
        return this.boxedIterator.hasNext();
    }

    public Object next() {
        return new AnnotatedValue(this.boxedIterator.next(), this.annotations);
    }

    @Override
    public void remove() {
        this.boxedIterator.remove();
    }

    public Object unbox() {
        return this.boxedIterator;
    }
}

