/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import com.atlassian.confluence.velocity.introspection.AnnotatedValue;
import com.atlassian.confluence.velocity.introspection.AnnotationValidationUtils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.apache.velocity.util.introspection.VelMethod;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationBoxingMethod
implements VelMethod {
    private final VelMethod delegate;
    private final Collection<Annotation> returnValAnnotations;

    public AnnotationBoxingMethod(VelMethod delegateMethod, Collection<Annotation> annotations) {
        Assert.notNull((Object)delegateMethod, (String)"degateMethod must not be null");
        Assert.notNull(annotations, (String)"annotations must not be null");
        AnnotationValidationUtils.assertContainsNoNulls(annotations, "annotations must not contain nulls");
        this.delegate = delegateMethod;
        this.returnValAnnotations = annotations;
    }

    public Object invoke(Object o, Object[] params) throws Exception {
        Object obj = this.delegate.invoke(o, params);
        if (obj == null) {
            return null;
        }
        return new AnnotatedValue(obj, this.returnValAnnotations);
    }

    public boolean isCacheable() {
        return this.delegate.isCacheable();
    }

    public String getMethodName() {
        return this.delegate.getMethodName();
    }

    public Class getReturnType() {
        return this.delegate.getReturnType();
    }
}

