/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import com.atlassian.confluence.velocity.introspection.AnnotatedValue;
import com.atlassian.confluence.velocity.introspection.AnnotatedValueHelper;
import com.atlassian.confluence.velocity.introspection.AnnotatedValueHelperFactory;
import com.atlassian.confluence.velocity.introspection.AnnotatedValueIterator;
import com.atlassian.confluence.velocity.introspection.AnnotatedValueStringHandler;
import com.atlassian.confluence.velocity.introspection.AnnotationBoxedElement;
import com.atlassian.confluence.velocity.introspection.AnnotationBoxingMethod;
import com.atlassian.confluence.velocity.introspection.AnnotationBoxingPropertyGet;
import com.atlassian.confluence.velocity.introspection.AnnotationPreservingInvocationHandler;
import com.atlassian.confluence.velocity.introspection.BoxingUtils;
import com.atlassian.confluence.velocity.introspection.InterfaceMethods;
import com.atlassian.confluence.velocity.introspection.InterfaceMethodsSet;
import com.atlassian.confluence.velocity.introspection.MethodAnnotator;
import com.atlassian.confluence.velocity.introspection.ObjectClassResolver;
import com.atlassian.confluence.velocity.introspection.ProxiedMethod;
import com.atlassian.confluence.velocity.introspection.ReturnValueAnnotator;
import com.atlassian.confluence.velocity.introspection.UnboxingMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBoxingUberspect
extends UberspectImpl
implements RuntimeServicesAware {
    private static final Logger log = Logger.getLogger(AnnotationBoxingUberspect.class);
    private static final InterfaceMethodsSet ANNOTATION_PRESERVING_METHODS = AnnotationBoxingUberspect.getAnnotationPreservingCollectionMethods();
    private static final MethodAnnotator RETURN_VALUE_ANNOTATOR = new ReturnValueAnnotator();
    private RuntimeServices runtimeServices;
    private final ObjectClassResolver CLASS_RESOLVER = new ObjectClassResolver(){

        public Class resolveClass(Object object) {
            return AnnotationBoxingUberspect.this.getClassForTargetObject(object);
        }
    };

    public void init() {
        super.init();
        this.runtimeServices.getApplicationEventCartridge().addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)new AnnotatedValueStringHandler());
    }

    private static InterfaceMethodsSet getAnnotationPreservingCollectionMethods() {
        try {
            InterfaceMethods preservingMapMethods = new InterfaceMethods(Map.class.getMethod("get", Object.class));
            InterfaceMethods preservingListMethods = new InterfaceMethods(List.class.getMethod("get", Integer.TYPE));
            HashSet<InterfaceMethods> preservingMethods = new HashSet<InterfaceMethods>();
            preservingMethods.add(preservingListMethods);
            preservingMethods.add(preservingMapMethods);
            return new InterfaceMethodsSet(preservingMethods);
        }
        catch (NoSuchMethodException ex) {
            log.error((Object)"Could not find collection method via reflection. Collection inheritance will not function.", (Throwable)ex);
            return new InterfaceMethodsSet();
        }
    }

    public final VelMethod getMethod(Object obj, String methodName, Object[] args, Info info) throws Exception {
        AnnotatedValueHelper valueHelper = AnnotatedValueHelperFactory.getValueHelper(obj, this.CLASS_RESOLVER);
        Object[] unboxedArgs = BoxingUtils.unboxArrayElements(args);
        VelMethod method = super.getMethod(valueHelper.unbox(), methodName, unboxedArgs, info);
        if (method == null) {
            return null;
        }
        method = this.checkAndGenerateAnnotationPreservingProxy(valueHelper, method, unboxedArgs, info);
        Method refMethod = this.introspector.getMethod(valueHelper.getTargetClass(), methodName, unboxedArgs);
        Collection<Annotation> returnValueAnnotations = this.getMethodAnnotations(refMethod);
        if (!returnValueAnnotations.isEmpty()) {
            method = new AnnotationBoxingMethod(method, returnValueAnnotations);
        }
        return new UnboxingMethod(method);
    }

    private VelMethod checkAndGenerateAnnotationPreservingProxy(AnnotatedValueHelper valueHelper, VelMethod velocityMethod, Object[] unboxedArgs, Info info) throws Exception {
        if (!valueHelper.isBoxedValue()) {
            return velocityMethod;
        }
        AnnotationBoxedElement annotatedValue = valueHelper.getBoxedValueWithInheritedAnnotations();
        if (annotatedValue != null) {
            return this.methodProxy(annotatedValue, ANNOTATION_PRESERVING_METHODS, info, unboxedArgs, velocityMethod);
        }
        return velocityMethod;
    }

    public final Iterator getIterator(Object obj, Info info) throws Exception {
        if (!(obj instanceof AnnotatedValue)) {
            return super.getIterator(obj, info);
        }
        AnnotatedValue annotatedValue = (AnnotatedValue)obj;
        Iterator iterator = super.getIterator(annotatedValue.unbox(), info);
        if (iterator == null) {
            return null;
        }
        Collection<Annotation> inheritedAnnotations = annotatedValue.getCollectionInheritableAnnotations();
        if (inheritedAnnotations.isEmpty()) {
            return iterator;
        }
        return new AnnotatedValueIterator(iterator, inheritedAnnotations);
    }

    public final VelPropertyGet getPropertyGet(Object obj, String identifier, Info info) throws Exception {
        AnnotatedValueHelper valueHelper = AnnotatedValueHelperFactory.getValueHelper(obj, this.CLASS_RESOLVER);
        VelPropertyGet getter = super.getPropertyGet(valueHelper.unbox(), identifier, info);
        if (getter == null) {
            return null;
        }
        log.debug((Object)("Getting introspector method for getter: " + getter.getMethodName()));
        Method refMethod = this.introspector.getMethod(valueHelper.getTargetClass(), getter.getMethodName(), new Object[0]);
        log.debug((Object)("got method: " + refMethod));
        if (refMethod == null) {
            return getter;
        }
        Collection<Annotation> annotations = this.getMethodAnnotations(refMethod);
        log.debug((Object)("Got return annotations: " + annotations));
        if (annotations.isEmpty()) {
            return getter;
        }
        return new AnnotationBoxingPropertyGet(getter, annotations);
    }

    private VelMethod methodProxy(AnnotationBoxedElement value, InterfaceMethodsSet interfaceMethodsSet, Info info, Object[] unboxedArgs, VelMethod velMethod) throws Exception {
        InterfaceMethodsSet implementedInterfaceMethods = interfaceMethodsSet.getImplementedMethods(value.unbox().getClass());
        if (implementedInterfaceMethods.isEmpty()) {
            return velMethod;
        }
        Set<Class> implementedInterfaces = implementedInterfaceMethods.getInterfaces();
        log.debug((Object)("Object implements: " + implementedInterfaces));
        Object proxiedObject = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), implementedInterfaces.toArray(new Class[implementedInterfaces.size()]), (InvocationHandler)new AnnotationPreservingInvocationHandler(value, implementedInterfaceMethods.getMethods()));
        VelMethod proxiedMethod = super.getMethod(proxiedObject, velMethod.getMethodName(), unboxedArgs, info);
        if (proxiedMethod == null) {
            return velMethod;
        }
        log.debug((Object)("Proxying method: " + proxiedMethod));
        return new ProxiedMethod(proxiedMethod, proxiedObject);
    }

    public void setRuntimeServices(RuntimeServices runtimeServices) {
        this.runtimeServices = runtimeServices;
    }

    protected Collection<Annotation> getMethodAnnotations(Method method) {
        return Collections.unmodifiableCollection(RETURN_VALUE_ANNOTATOR.getAnnotationsForMethod(method));
    }

    protected Class getClassForTargetObject(Object targetObject) {
        return targetObject.getClass();
    }
}

