/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InterfaceMethods {
    private final Set<Method> methods;
    private final Class declaringInterface;

    public InterfaceMethods(Method ... methods) {
        Assert.notEmpty((Object[])methods, (String)"At least one method must be provided");
        HashSet declaringClasses = new HashSet();
        for (Method method : methods) {
            Assert.isTrue((boolean)method.getDeclaringClass().isInterface(), (String)"Provided methods must be from an interface");
            declaringClasses.add(method.getDeclaringClass());
            Assert.isTrue((declaringClasses.size() == 1 ? 1 : 0) != 0, (String)"Provided methods must be from the same interface");
        }
        this.declaringInterface = (Class)declaringClasses.iterator().next();
        this.methods = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList(methods)));
    }

    public boolean isImplementation(Class clazz) {
        return this.getDeclaringInterface().isAssignableFrom(clazz);
    }

    public Set<Method> getMethods() {
        return this.methods;
    }

    public Class getDeclaringInterface() {
        return this.declaringInterface;
    }
}

