/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.velocity.introspection;

import com.atlassian.confluence.velocity.introspection.BoxingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.velocity.util.introspection.VelMethod;
import org.springframework.util.Assert;

final class UnboxingMethod
implements VelMethod {
    private final VelMethod delegateMethod;

    public UnboxingMethod(VelMethod delegateMethod) {
        Assert.notNull((Object)delegateMethod, (String)"delegateMethod must not be null");
        this.delegateMethod = delegateMethod;
    }

    public Object invoke(Object o, Object[] objects) throws Exception {
        Object[] unboxedArgs = BoxingUtils.unboxArrayElements(objects);
        this.unboxListArgumentElements(unboxedArgs);
        return this.delegateMethod.invoke(BoxingUtils.unboxObject(o), unboxedArgs);
    }

    public boolean isCacheable() {
        return this.delegateMethod.isCacheable();
    }

    public String getMethodName() {
        return this.delegateMethod.getMethodName();
    }

    public Class getReturnType() {
        return this.delegateMethod.getReturnType();
    }

    private void unboxListArgumentElements(Object[] arguments) {
        for (int x = 0; x < arguments.length; ++x) {
            if (!(arguments[x] instanceof List)) continue;
            ArrayList unboxedList = new ArrayList((List)arguments[x]);
            ListIterator<Object> iterator = unboxedList.listIterator();
            while (iterator.hasNext()) {
                iterator.set(BoxingUtils.unboxObject(iterator.next()));
            }
            arguments[x] = unboxedList;
        }
    }
}

