/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.log4j.Category;

public class MergeVisitor
implements RevisionVisitor {
    public static final Category log = Category.getInstance(MergeVisitor.class);
    private LinkedList anchorPointMappings;
    private Revision firstRevision = null;
    private boolean isFirst = false;
    private boolean conflictDetected = false;
    private Map deltaMap;

    public boolean wasConflictDetected() {
        return this.conflictDetected;
    }

    public void init(Object[] orig) {
        this.anchorPointMappings = new LinkedList();
        for (int i = 0; i < orig.length; ++i) {
            this.anchorPointMappings.add(new Integer(i));
        }
        this.deltaMap = new HashMap();
    }

    public void visit(Revision revision) {
        if (this.firstRevision == null) {
            this.firstRevision = revision;
        }
        this.isFirst = this.firstRevision == revision;
    }

    public void visit(DeleteDelta delta) {
        if (this.checkConflict((Delta)delta)) {
            return;
        }
        int index = delta.getOriginal().anchor();
        int upperIndex = delta.getOriginal().anchor() + delta.getOriginal().size();
        if (!this.isFirst) {
            int mappedOriginalAnchorPoint = this.getMappedAnchorPoint(delta.getOriginal().anchor());
            int mappedRevisedAnchorPoint = this.getMappedAnchorPoint(delta.getRevised().anchor());
            if (mappedOriginalAnchorPoint == -1 || mappedRevisedAnchorPoint == -1) {
                this.conflictDetected = true;
                return;
            }
            delta.getOriginal().anchor = mappedOriginalAnchorPoint;
            delta.getRevised().anchor = mappedRevisedAnchorPoint;
        } else {
            Iterator it = this.anchorPointMappings.iterator();
            while (it.hasNext()) {
                int j = (Integer)it.next();
                if (index > j || j >= upperIndex) continue;
                it.remove();
            }
        }
    }

    public void visit(ChangeDelta delta) {
        this.checkConflict((Delta)delta);
    }

    public void visit(AddDelta delta) {
        if (this.checkConflict((Delta)delta)) {
            return;
        }
        int index = this.getMappedAnchorPoint(delta.getOriginal().anchor());
        if (index == -1) {
            this.conflictDetected = true;
            return;
        }
        if (this.isFirst) {
            for (int i = 0; i < delta.getRevised().size(); ++i) {
                this.anchorPointMappings.add(index, new Integer(delta.getOriginal().anchor()));
            }
        } else {
            delta.getOriginal().anchor = index;
            delta.getRevised().anchor = index;
        }
    }

    private boolean checkConflict(Delta delta) {
        if (this.conflictDetected) {
            return true;
        }
        Integer key = new Integer(delta.getOriginal().anchor());
        if (this.deltaMap.containsKey(key)) {
            Delta otherDelta = (Delta)this.deltaMap.get(key);
            this.conflictDetected = !delta.toString().equals(otherDelta.toString());
            return this.conflictDetected;
        }
        this.deltaMap.put(key, delta);
        return false;
    }

    private int getMappedAnchorPoint(int origAnchorPoint) {
        int i = 0;
        Iterator iterator = this.anchorPointMappings.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            if (j == origAnchorPoint) {
                return i;
            }
            ++i;
        }
        int lastMapping = (Integer)this.anchorPointMappings.getLast();
        if (lastMapping + 1 == origAnchorPoint) {
            return this.anchorPointMappings.size();
        }
        return -1;
    }
}

