/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.NodeStatus;
import com.atlassian.confluence.cluster.NodeStatusFactory;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.impl.ExportUtils;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteClusterInformation;
import com.atlassian.confluence.rpc.soap.beans.RemoteNodeStatus;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.plugin.PluginManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.tangosol.net.Member;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class AdminSoapService {
    public static final Category log = Category.getInstance(AdminSoapService.class);
    private ConfluenceIndexManager indexManager;
    private ImportExportManager importExportManager;
    private BootstrapManager bootstrapManager;
    private SpaceManager spaceManager;
    private GateKeeper gateKeeper;
    SoapServiceHelper soapServiceHelper;
    private ClusterManager clusterManager;
    private PermissionManager permissionManager;
    private SettingsManager settingsManager;
    private PluginManager pluginManger;

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public boolean isConfluenceAdministrator(User user) throws RemoteException {
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String exportSite(boolean exportAttachments) throws RemoteException {
        String downloadPath = null;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.isConfluenceAdministrator(user)) {
            throw new RemoteException("Authenticated user [" + user + "] is not a Confluence Administrator.");
        }
        try {
            DefaultExportContext exportContext = DefaultExportContext.getXmlBackupInstance();
            exportContext.setExportAttachments(exportAttachments);
            exportContext.setExportHierarchy(false);
            exportContext.setExportComments(false);
            String archivePath = this.importExportManager.exportAs((ExportContext)exportContext, new ProgressMeter());
            downloadPath = this.importExportManager.prepareDownloadPath(archivePath);
            this.gateKeeper.addKey(downloadPath, user);
        }
        catch (ImportExportException e) {
            return "Could not export space: " + (Object)((Object)e);
        }
        catch (IOException e) {
            return "Could not export space: " + e;
        }
        return this.bootstrapManager.getBaseUrl() + downloadPath;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setIndexManager(ConfluenceIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public RemoteServerInfo getServerInfo() throws RemoteException {
        return new RemoteServerInfo();
    }

    public boolean flushIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        while (this.indexManager.isReIndexing()) {
            System.out.println("reindexing");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.indexManager.flushQueue();
        return true;
    }

    public boolean clearIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        this.indexManager.resetIndexQueue();
        return true;
    }

    public RemoteClusterInformation getClusterInformation() {
        return new RemoteClusterInformation(this.clusterManager.getClusterInformation());
    }

    public RemoteNodeStatus[] getClusterNodeStatuses() {
        ArrayList<RemoteNodeStatus> l = new ArrayList<RemoteNodeStatus>();
        Map m = NodeStatusFactory.getNodeStatusesForCluster((ClusterManager)this.clusterManager);
        for (Map.Entry e : m.entrySet()) {
            Member member = (Member)e.getKey();
            NodeStatus nodeStatus = (NodeStatus)e.getValue();
            l.add(new RemoteNodeStatus(member.getId(), nodeStatus));
        }
        return l.toArray(new RemoteNodeStatus[0]);
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importSpace(byte[] importData) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.isConfluenceAdministrator(user)) {
            throw new RemoteException("Authenticated user [" + user + "] is not a Confluence Administrator.");
        }
        try {
            File tmp = File.createTempFile("confluence-import-", ".tmp");
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(tmp);
                fout.write(importData);
                fout.close();
            }
            catch (IOException ex) {
                log.error((Object)"Unable to create temporary file", (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException ex) {}
            }
            DefaultImportContext defaultImportContext = new DefaultImportContext(tmp.getAbsolutePath(), user);
            defaultImportContext.setDeleteWorkingFile(true);
            if (!ExportUtils.isSpaceImport((File)tmp)) throw new RemoteException("Invalid import type - can only import spaces");
            String spaceKey = ExportUtils.getSpaceKeyFromExportZip((File)tmp);
            if (this.spaceManager.getSpace(spaceKey) != null) {
                throw new RemoteException("Space " + spaceKey + " already exists.  Import aborted.");
            }
            defaultImportContext.setSpaceKeyOfSpaceImport(ExportUtils.getSpaceKeyFromExportZip((File)tmp));
            this.importExportManager.importAs((Object)"TYPE_ALL_DATA", (ImportContext)defaultImportContext);
            return true;
        }
        catch (ImportExportException e) {
            throw new RemoteException("Could not import space", (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteException("Could not import space", (Throwable)e);
        }
        catch (UnexpectedImportZipFileContents unexpectedImportZipFileContents) {
            throw new RemoteException("Could not import space", (Throwable)unexpectedImportZipFileContents);
        }
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public boolean setEnableWysiwyg(boolean value) {
        Settings settings = this.settingsManager.getGlobalSettings();
        settings.setEnableWysiwyg(value);
        this.settingsManager.updateGlobalSettings(settings);
        return true;
    }

    public void setPluginManger(PluginManager pluginManger) {
        this.pluginManger = pluginManger;
    }

    public boolean isRpcPluginEnabled() {
        return ((PluginManager)ContainerManager.getComponent((String)"pluginManager")).isPluginEnabled("confluence.extra.functestrpc");
    }

    public boolean setEnableAnonymousAccess(boolean value) {
        PermissionCheckDispatcherResultCache permissionCheckDispatcher;
        SpacePermissionManager manager = (SpacePermissionManager)ContainerManager.getComponent((String)"spacePermissionManager");
        List globalPermissions = manager.getGlobalPermissions("USECONFLUENCE");
        SpacePermission globalAnonymousPermission = null;
        for (SpacePermission spacePermission : globalPermissions) {
            if (!spacePermission.isAnonymousPermission()) continue;
            globalAnonymousPermission = spacePermission;
        }
        if (!value) {
            if (globalAnonymousPermission != null) {
                manager.removePermission(globalAnonymousPermission);
            }
        } else if (globalAnonymousPermission == null) {
            manager.savePermission(new SpacePermission("USECONFLUENCE", null));
        }
        if ((permissionCheckDispatcher = (PermissionCheckDispatcherResultCache)ContainerManager.getComponent((String)"permissionCheckDispatcherResultCache")) != null) {
            permissionCheckDispatcher.flush();
        }
        return true;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

