/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.SoapUtils;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntrySummary;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.core.exception.InfrastructureException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BlogsSoapService {
    PageManager pageManager;
    SoapServiceHelper soapServiceHelper;
    private SpaceManager spaceManager;

    public RemoteBlogEntry getBlogEntryByDayAndTitle(String spaceKey, int dayOfMonth, String postTitle) throws RemoteException {
        GregorianCalendar calDate = new GregorianCalendar();
        calDate.set(5, dayOfMonth);
        BlogPost blogPost = this.pageManager.getBlogPost(spaceKey, postTitle, (Calendar)calDate);
        this.soapServiceHelper.assertCanView((AbstractPage)blogPost);
        return new RemoteBlogEntry(blogPost);
    }

    public RemoteBlogEntry getBlogEntry(long entryId) throws RemoteException {
        BlogPost entry = (BlogPost)this.pageManager.getAbstractPage(entryId);
        this.soapServiceHelper.assertCanView((AbstractPage)entry);
        return new RemoteBlogEntry((BlogPost)this.pageManager.getAbstractPage(entryId));
    }

    public RemoteBlogEntrySummary[] getBlogEntries(String spaceKey) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(spaceKey);
        return SoapUtils.getBlogEntrySummaries(this.spaceManager.getBlogPosts(space, true));
    }

    public RemoteBlogEntry storeBlogEntry(RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        if (remoteBlogEntry.getId() <= 0L) {
            return this.createBlog(remoteBlogEntry);
        }
        return this.updateBlog(remoteBlogEntry);
    }

    private RemoteBlogEntry createBlog(RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        BlogPost blogPost;
        Space space = this.soapServiceHelper.retrieveSpace(remoteBlogEntry.getSpace());
        this.soapServiceHelper.assertCanView(space);
        this.soapServiceHelper.assertCanCreateBlogPost(space);
        Calendar publishDateCalendar = Calendar.getInstance();
        if (remoteBlogEntry.getPublishDate() != null) {
            publishDateCalendar.setTime(remoteBlogEntry.getPublishDate());
        }
        if ((blogPost = this.pageManager.getBlogPost(space.getKey(), remoteBlogEntry.getTitle(), publishDateCalendar)) != null) {
            throw new RemoteException("A blog post with title '" + remoteBlogEntry.getTitle() + "' already exists for date: " + publishDateCalendar);
        }
        if (remoteBlogEntry.getPublishDate() != null && remoteBlogEntry.getPublishDate().after(new Date())) {
            throw new RemoteException("A publish date for a blog post cannot be in a future.");
        }
        blogPost = new BlogPost();
        blogPost.setSpace(space);
        blogPost.setTitle(remoteBlogEntry.getTitle());
        blogPost.setContent(remoteBlogEntry.getContent());
        blogPost.setCreationDate(remoteBlogEntry.getPublishDate());
        this.pageManager.saveContentEntity((ContentEntityObject)blogPost, null);
        return new RemoteBlogEntry(blogPost);
    }

    private RemoteBlogEntry updateBlog(RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        BlogPost originalBlog;
        BlogPost blogPost = this.pageManager.getBlogPost(remoteBlogEntry.getId());
        this.soapServiceHelper.assertCanModify((AbstractPage)blogPost);
        if (blogPost == null) {
            throw new RemoteException("The blog post with id " + remoteBlogEntry.getId() + " you are trying to update does not exist.)");
        }
        if (!blogPost.getSpace().getKey().equals(remoteBlogEntry.getSpace())) {
            throw new RemoteException("You can't change an existing page's space.");
        }
        try {
            originalBlog = (BlogPost)blogPost.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InfrastructureException("Uh oh, couldn't clone a blog?!");
        }
        blogPost.setContent(remoteBlogEntry.getContent());
        blogPost.setTitle(remoteBlogEntry.getTitle());
        this.pageManager.saveContentEntity((ContentEntityObject)blogPost, (ContentEntityObject)originalBlog, null);
        return new RemoteBlogEntry(blogPost);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }
}

