/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.UploadedFile;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Hashtable parameters = new Hashtable();
    protected Hashtable files = new Hashtable();

    public MultipartRequest(HttpServletRequest httpServletRequest, String string) throws IOException {
        this(httpServletRequest, string, 0x100000);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n) throws IOException {
        this(httpServletRequest, string, n, null, null);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, String string2) throws IOException {
        this(httpServletRequest, string, 0x100000, string2, null);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n, FileRenamePolicy fileRenamePolicy) throws IOException {
        this(httpServletRequest, string, n, null, fileRenamePolicy);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n, String string2) throws IOException {
        this(httpServletRequest, string, n, string2, null);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n, String string2, FileRenamePolicy fileRenamePolicy) throws IOException {
        Part part;
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + string);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + string);
        }
        MultipartParser multipartParser = new MultipartParser(httpServletRequest, n);
        if (string2 != null) {
            multipartParser.setEncoding(string2);
        }
        while ((part = multipartParser.readNextPart()) != null) {
            String string3;
            Part part2;
            String string4 = part.getName();
            if (part.isParam()) {
                part2 = (ParamPart)part;
                string3 = ((ParamPart)part2).getStringValue();
                Vector<String> vector = (Vector<String>)this.parameters.get(string4);
                if (vector == null) {
                    vector = new Vector<String>();
                    this.parameters.put(string4, vector);
                }
                vector.addElement(string3);
                continue;
            }
            if (!part.isFile()) continue;
            part2 = (FilePart)part;
            string3 = ((FilePart)part2).getFileName();
            if (string3 != null) {
                ((FilePart)part2).setRenamePolicy(fileRenamePolicy);
                ((FilePart)part2).writeTo(file);
                this.files.put(string4, new UploadedFile(file.toString(), string3, ((FilePart)part2).getContentType()));
                continue;
            }
            this.files.put(string4, new UploadedFile(null, null, null));
        }
    }

    public MultipartRequest(ServletRequest servletRequest, String string) throws IOException {
        this((HttpServletRequest)servletRequest, string);
    }

    public MultipartRequest(ServletRequest servletRequest, String string, int n) throws IOException {
        this((HttpServletRequest)servletRequest, string, n);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getParameter(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = (String)vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFilesystemName(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFilesystemName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getContentType(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getContentType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

