/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.io.FastBufferedReader;
import electric.util.io.FastStringReader;
import electric.util.io.Streams;
import electric.util.string.Strings;
import electric.xml.Attribute;
import electric.xml.CData;
import electric.xml.Comment;
import electric.xml.DocType;
import electric.xml.Element;
import electric.xml.Fragment;
import electric.xml.Implementation;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import electric.xml.ParseException;
import electric.xml.Text;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.ProcessingInstruction;

public class Document
extends Parent
implements org.w3c.dom.Document {
    public static final int KEEP_WHITESPACE = 1;
    public static final int MAJOR_VERSION = 6;
    public static final int MINOR_VERSION = 1;
    private static final Implementation implementation = new Implementation();
    private Hashtable context;
    private boolean stripped = true;
    private String version = "1.0";
    private String encoding = "UTF-8";
    private boolean standalone = false;
    private boolean setStandalone = false;
    private boolean writeXMLDecl = true;

    public Document() {
    }

    public Document(Hashtable hashtable) {
        this.context = hashtable;
    }

    public Document(String string) throws ParseException {
        this(string, 0);
    }

    public Document(String string, int n) throws ParseException {
        new NodeReader(new FastStringReader(string), n).parse(this);
    }

    public Document(byte[] byArray) throws ParseException {
        this(byArray, null, 0);
    }

    public Document(byte[] byArray, int n) throws ParseException {
        this(byArray, null, n);
    }

    public Document(byte[] byArray, Hashtable hashtable) throws ParseException {
        this(byArray, hashtable, 0);
    }

    public Document(byte[] byArray, Hashtable hashtable, int n) throws ParseException {
        this.context = hashtable;
        try {
            new NodeReader(new FastStringReader(Strings.toString(byArray)), n).parse(this);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ParseException(unsupportedEncodingException.toString());
        }
    }

    public Document(File file) throws ParseException {
        this(file, 0);
    }

    public Document(File file, int n) throws ParseException {
        try {
            new NodeReader(new FastBufferedReader(Streams.getReader(file)), n).parse(this);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public Document(InputStream inputStream) throws ParseException {
        this(inputStream, 0);
    }

    public Document(InputStream inputStream, int n) throws ParseException {
        try {
            new NodeReader(new FastBufferedReader(Streams.getReader(inputStream)), n).parse(this);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public Document(Reader reader) throws ParseException {
        new NodeReader(reader, 0).parse(this);
    }

    public Document(Reader reader, int n) throws ParseException {
        new NodeReader(reader, n).parse(this);
    }

    public Document(Reader reader, Hashtable hashtable) throws ParseException {
        this.context = hashtable;
        new NodeReader(reader, 0).parse(this);
    }

    public Document(Reader reader, Hashtable hashtable, int n) throws ParseException {
        this.context = hashtable;
        new NodeReader(reader, n).parse(this);
    }

    public Document(NodeReader nodeReader) throws ParseException {
        nodeReader.parse(this);
    }

    public Document(NodeReader nodeReader, Hashtable hashtable) throws ParseException {
        this.context = hashtable;
        nodeReader.parse(this);
    }

    public Document(Element element) {
        this.setRoot(element);
    }

    public Document(Document document) {
        super(document);
        this.context = document.context;
        this.version = document.version;
        this.encoding = document.encoding;
        this.standalone = document.standalone;
        this.setStandalone = document.setStandalone;
        this.writeXMLDecl = document.writeXMLDecl;
    }

    public boolean isStripped() {
        return this.stripped;
    }

    public Object clone() {
        return new Document(this);
    }

    public Document getDocument() {
        return this;
    }

    public Element getRoot() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element newRoot() {
        return this.setRoot(new Element());
    }

    public Element setRoot(Element element) {
        Element element2 = this.getRoot();
        if (element2 != null) {
            element2.replaceWith(element);
        } else {
            this.addChild(element);
        }
        return element;
    }

    public Element setRoot(String string) {
        Element element = this.newRoot();
        element.setName(string);
        return element;
    }

    public Element setRoot(String string, String string2) {
        Element element = this.newRoot();
        element.setName(string, string2);
        return element;
    }

    public Element setRoot(String string, String string2, String string3) {
        Element element = this.newRoot();
        element.setNamespace(string, string3);
        element.setName(string, string2);
        return element;
    }

    public DocType getDocType() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof DocType) {
                return (DocType)node;
            }
            node = node.next;
        }
        return null;
    }

    public void read(NodeReader nodeReader) throws IOException, NamespaceException {
        this.stripped = nodeReader.isStrip();
        int n = 0;
        this.writeXMLDecl = false;
        while (true) {
            StringBuffer stringBuffer;
            if ((stringBuffer = nodeReader.readWhitespace()) != null && !nodeReader.isStrip()) {
                new Text(this).setString(stringBuffer.toString());
            }
            nodeReader.mark(2);
            int n2 = nodeReader.peekRead();
            int n3 = nodeReader.peekRead();
            nodeReader.reset();
            if (n2 == -1) break;
            if (n3 == 33 && nodeReader.peekString("<!--")) {
                nodeReader.read(new Comment(this));
                continue;
            }
            if (n3 == 33 && nodeReader.peekString("<!DOCTYPE")) {
                nodeReader.read(new DocType(this));
                continue;
            }
            if (n3 == 63 && nodeReader.peekString("<?xml ")) {
                this.writeXMLDecl = true;
                this.readXMLDecl(nodeReader);
                continue;
            }
            if (n3 == 63) {
                nodeReader.read(new Instruction(this));
                continue;
            }
            Element element = new Element();
            this.addChild(element);
            nodeReader.read(element);
            ++n;
        }
        if (n != 1) {
            throw new IOException("the document does not have exactly one root");
        }
        nodeReader.skipWhitespace();
        if (nodeReader.read() != -1) {
            throw new IOException("extra stuff at the end");
        }
    }

    public void write(NodeWriter nodeWriter) throws IOException {
        if (this.writeXMLDecl) {
            this.writeXMLDecl(nodeWriter);
        }
        Node node = this.children.first;
        while (node != null) {
            nodeWriter.write(node);
            if (node.next != null && this.stripped) {
                nodeWriter.writeEOL();
            }
            node = node.next;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
        this.writeXMLDecl = true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.writeXMLDecl = true;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
        this.setStandalone = true;
        this.writeXMLDecl = true;
    }

    public void setWriteXMLDecl(boolean bl) {
        this.writeXMLDecl = bl;
    }

    public boolean getWriteXMLDecl() {
        return this.writeXMLDecl;
    }

    private void readXMLDecl(NodeReader nodeReader) throws IOException {
        nodeReader.skip("<?xml ".length());
        int n = 0;
        do {
            String string = nodeReader.readToken();
            nodeReader.readChar(61);
            nodeReader.skipWhitespace();
            int n2 = nodeReader.read();
            String string2 = null;
            if (n2 == 34) {
                string2 = nodeReader.readToPattern("\"", 66);
            } else if (n2 == 39) {
                string2 = nodeReader.readToPattern("'", 66);
            } else {
                throw new IOException("missing quote at start of XMLDecl attribute");
            }
            if (string.equals("version")) {
                this.setVersion(string2);
            } else if (string.equals("encoding")) {
                this.setEncoding(string2);
            } else if (string.equals("standalone")) {
                this.setStandalone(string2.equals("yes"));
            } else {
                throw new IOException(string + " is invalid attribute for XMLDecl");
            }
            nodeReader.skipWhitespace();
        } while ((n = nodeReader.peek()) != 63);
        nodeReader.readChar(63);
        nodeReader.readChar(62);
    }

    private void writeXMLDecl(NodeWriter nodeWriter) throws IOException {
        nodeWriter.writeIndent();
        nodeWriter.write("<?xml ");
        nodeWriter.write("version");
        nodeWriter.write("='");
        nodeWriter.write(this.version);
        nodeWriter.write("' ");
        nodeWriter.write("encoding");
        nodeWriter.write("='");
        nodeWriter.write(this.encoding);
        nodeWriter.write("'");
        if (this.setStandalone) {
            nodeWriter.write(" ");
            nodeWriter.write("standalone");
            nodeWriter.write("='");
            nodeWriter.write(this.standalone ? "yes" : "no");
            nodeWriter.write("'");
        }
        nodeWriter.write("?>");
        nodeWriter.writeEOL();
    }

    public Hashtable getContext() {
        return this.context;
    }

    public void setContext(Hashtable hashtable) {
        this.context = hashtable;
    }

    public String getNamespace(String string) {
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return this.context == null ? null : (String)this.context.get(string);
    }

    protected void addNamespacePrefixes(String string, Vector vector, Vector vector2) {
        if (this.context == null) {
            return;
        }
        Enumeration enumeration = this.context.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (vector.contains(string2) || !this.context.get(string2).equals(string)) continue;
            vector2.addElement(string2);
        }
    }

    public String getNamespacePrefix(String string) {
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        if (this.context == null) {
            return null;
        }
        Enumeration enumeration = this.context.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.context.get(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public int size() {
        int n = 0;
        if (this.writeXMLDecl) {
            n += "<?xml ".length() + "version".length() + 7 + this.version.length() + "encoding".length() + this.encoding.length();
            if (this.setStandalone) {
                n += 4 + "standalone".length() + (this.standalone ? 3 : 2);
            }
            n += "?>".length();
        }
        return n + super.size();
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        Instruction instruction;
        if (node instanceof Instruction && (instruction = (Instruction)node).getTarget().startsWith("xml")) {
            try {
                StringReader stringReader = new StringReader("<?xml " + instruction.getContent() + "?>");
                NodeReader nodeReader = new NodeReader(stringReader);
                this.readXMLDecl(nodeReader);
                return instruction;
            }
            catch (IOException iOException) {
                short s = 5;
                throw new DOMException(s, iOException.toString());
            }
        }
        return super.appendChild(node);
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Attr createAttribute(String string) {
        return new Attribute(string, null);
    }

    public Attr createAttributeNS(String string, String string2) {
        String[] stringArray = Element.getParts(string2);
        Attribute attribute = new Attribute(stringArray[0], stringArray[1], null);
        attribute.namespace = string;
        return attribute;
    }

    public CDATASection createCDATASection(String string) {
        return new CData(string);
    }

    public org.w3c.dom.Comment createComment(String string) {
        return new Comment(string);
    }

    public DocumentFragment createDocumentFragment() {
        return new Fragment();
    }

    public org.w3c.dom.Element createElement(String string) {
        return new Element(string);
    }

    public org.w3c.dom.Element createElementNS(String string, String string2) {
        String[] stringArray = Element.getParts(string2);
        Element element = new Element(stringArray[1]);
        element.prefix = stringArray[0];
        element.namespace = string;
        return element;
    }

    public EntityReference createEntityReference(String string) {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return new Instruction(string, string2);
    }

    public org.w3c.dom.Text createTextNode(String string) {
        return new Text(string);
    }

    public DocumentType getDoctype() {
        return this.getDocType();
    }

    public org.w3c.dom.Element getDocumentElement() {
        return this.getRoot();
    }

    public org.w3c.dom.Element getElementById(String string) {
        return this.getElementWithId(string);
    }

    public org.w3c.dom.NodeList getElementsByTagName(String string) {
        NodeList nodeList = new NodeList();
        Element element = this.getRoot();
        if (element != null) {
            element.addElementsByTagName(string, nodeList);
        }
        return nodeList;
    }

    public org.w3c.dom.NodeList getElementsByTagNameNS(String string, String string2) {
        NodeList nodeList = new NodeList();
        Element element = this.getRoot();
        if (element != null) {
            element.addElementsByTagNameNS(string, string2, nodeList);
        }
        return nodeList;
    }

    public DOMImplementation getImplementation() {
        return implementation;
    }

    public org.w3c.dom.Node importNode(org.w3c.dom.Node node, boolean bl) {
        return node.cloneNode(bl);
    }
}

