/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOURIResolver;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.hyphenation.HyphenationTreeResolver;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.render.RendererFactory;
import org.apache.fop.render.XMLHandlerRegistry;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.xml.sax.SAXException;

public class FopFactory {
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    private static final float DEFAULT_SOURCE_RESOLUTION = 72.0f;
    private static final String DEFAULT_PAGE_HEIGHT = "11in";
    private static final String DEFAULT_PAGE_WIDTH = "8.26in";
    private static final boolean DEFAULT_STRICT_FO_VALIDATION = true;
    private static final boolean DEFAULT_STRICT_USERCONFIG_VALIDATION = true;
    private static final boolean DEFAULT_BREAK_INDENT_INHERITANCE = false;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$apps$FopFactory == null ? (class$org$apache$fop$apps$FopFactory = FopFactory.class$("org.apache.fop.apps.FopFactory")) : class$org$apache$fop$apps$FopFactory));
    private RendererFactory rendererFactory = new RendererFactory();
    private XMLHandlerRegistry xmlHandlers = new XMLHandlerRegistry();
    private ElementMappingRegistry elementMappingRegistry;
    private ContentHandlerFactoryRegistry contentHandlerFactoryRegistry = new ContentHandlerFactoryRegistry();
    private URIResolver foURIResolver = new FOURIResolver();
    private URIResolver uriResolver = null;
    private HyphenationTreeResolver hyphResolver;
    private ImageFactory imageFactory = new ImageFactory();
    private Configuration userConfig = null;
    private String baseURL;
    private String fontBaseURL;
    private String hyphenBaseURL;
    private boolean strictFOValidation = true;
    private boolean strictUserConfigValidation = true;
    private boolean enableBase14Kerning = false;
    private float sourceResolution = 72.0f;
    private float targetResolution = 72.0f;
    private String pageHeight = "11in";
    private String pageWidth = "8.26in";
    private boolean breakIndentInheritanceOnReferenceAreaBoundary = false;
    private LayoutManagerMaker lmMakerOverride = null;
    private Set ignoredNamespaces = new HashSet();
    private Map colorSpaceMap = null;
    static /* synthetic */ Class class$org$apache$fop$apps$FopFactory;

    protected FopFactory() {
        this.elementMappingRegistry = new ElementMappingRegistry(this);
        this.colorSpaceMap = Collections.synchronizedMap(new HashMap());
    }

    public static FopFactory newInstance() {
        return new FopFactory();
    }

    public FOUserAgent newFOUserAgent() {
        FOUserAgent userAgent = new FOUserAgent(this);
        return userAgent;
    }

    public Fop newFop(String outputFormat) throws FOPException {
        return new Fop(outputFormat, this.newFOUserAgent());
    }

    public Fop newFop(String outputFormat, FOUserAgent userAgent) throws FOPException {
        if (userAgent == null) {
            throw new NullPointerException("The userAgent parameter must not be null!");
        }
        return new Fop(outputFormat, userAgent);
    }

    public Fop newFop(String outputFormat, OutputStream stream) throws FOPException {
        return new Fop(outputFormat, this.newFOUserAgent(), stream);
    }

    public Fop newFop(String outputFormat, FOUserAgent userAgent, OutputStream stream) throws FOPException {
        if (userAgent == null) {
            throw new NullPointerException("The userAgent parameter must not be null!");
        }
        return new Fop(outputFormat, userAgent, stream);
    }

    public Fop newFop(FOUserAgent userAgent) throws FOPException {
        if (userAgent.getRendererOverride() == null && userAgent.getFOEventHandlerOverride() == null) {
            throw new IllegalStateException("Either the overriding renderer or the overriding FOEventHandler must be set when this factory method is used!");
        }
        return this.newFop(null, userAgent);
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.xmlHandlers;
    }

    public ElementMappingRegistry getElementMappingRegistry() {
        return this.elementMappingRegistry;
    }

    public ContentHandlerFactoryRegistry getContentHandlerFactoryRegistry() {
        return this.contentHandlerFactoryRegistry;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public void addElementMapping(ElementMapping elementMapping) {
        this.elementMappingRegistry.addElementMapping(elementMapping);
    }

    public void setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
        this.lmMakerOverride = lmMaker;
    }

    public LayoutManagerMaker getLayoutManagerMakerOverride() {
        return this.lmMakerOverride;
    }

    void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setFontBaseURL(String fontBaseURL) {
        this.fontBaseURL = fontBaseURL;
    }

    public String getFontBaseURL() {
        return this.fontBaseURL;
    }

    public String getHyphenBaseURL() {
        return this.hyphenBaseURL;
    }

    public void setHyphenBaseURL(final String hyphenBaseURL) {
        if (hyphenBaseURL != null) {
            this.hyphResolver = new HyphenationTreeResolver(){

                public Source resolve(String href) {
                    return FopFactory.this.resolveURI(href, hyphenBaseURL);
                }
            };
        }
        this.hyphenBaseURL = hyphenBaseURL;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public HyphenationTreeResolver getHyphenationTreeResolver() {
        return this.hyphResolver;
    }

    public void setStrictValidation(boolean validateStrictly) {
        this.strictFOValidation = validateStrictly;
    }

    public boolean validateStrictly() {
        return this.strictFOValidation;
    }

    public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
        return this.breakIndentInheritanceOnReferenceAreaBoundary;
    }

    public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean value) {
        this.breakIndentInheritanceOnReferenceAreaBoundary = value;
    }

    public boolean isBase14KerningEnabled() {
        return this.enableBase14Kerning;
    }

    public void setBase14KerningEnabled(boolean value) {
        this.enableBase14Kerning = value;
    }

    public float getSourceResolution() {
        return this.sourceResolution;
    }

    public float getSourcePixelUnitToMillimeter() {
        return 25.4f / this.getSourceResolution();
    }

    public void setSourceResolution(float dpi) {
        this.sourceResolution = dpi;
        log.info((Object)("source-resolution set to: " + this.sourceResolution + "dpi (px2mm=" + this.getSourcePixelUnitToMillimeter() + ")"));
    }

    public float getTargetResolution() {
        return this.targetResolution;
    }

    public float getTargetPixelUnitToMillimeter() {
        return 25.4f / this.targetResolution;
    }

    public void setTargetResolution(float dpi) {
        this.targetResolution = dpi;
    }

    public void setSourceResolution(int dpi) {
        this.setSourceResolution((float)dpi);
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
        log.info((Object)("Default page-height set to: " + pageHeight));
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(String pageWidth) {
        this.pageWidth = pageWidth;
        log.info((Object)("Default page-width set to: " + pageWidth));
    }

    public void ignoreNamespace(String namespaceURI) {
        this.ignoredNamespaces.add(namespaceURI);
    }

    public void ignoreNamespaces(Collection namespaceURIs) {
        this.ignoredNamespaces.addAll(namespaceURIs);
    }

    public boolean isNamespaceIgnored(String namespaceURI) {
        return this.ignoredNamespaces.contains(namespaceURI);
    }

    public Set getIgnoredNamespace() {
        return Collections.unmodifiableSet(this.ignoredNamespaces);
    }

    public void setUserConfig(File userConfigFile) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.buildFromFile(userConfigFile));
        }
        catch (ConfigurationException e) {
            throw new FOPException((Exception)((Object)e));
        }
    }

    public void setUserConfig(String uri) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.build(uri));
        }
        catch (ConfigurationException e) {
            throw new FOPException((Exception)((Object)e));
        }
    }

    public void setUserConfig(Configuration userConfig) throws FOPException {
        this.userConfig = userConfig;
        try {
            this.configure(userConfig);
        }
        catch (ConfigurationException e) {
            throw new FOPException((Exception)((Object)e));
        }
    }

    public Configuration getUserConfig() {
        return this.userConfig;
    }

    public Configuration getUserRendererConfig(String mimeType) {
        if (this.userConfig == null || mimeType == null) {
            return null;
        }
        Configuration userRendererConfig = null;
        Configuration[] cfgs = this.userConfig.getChild("renderers").getChildren("renderer");
        for (int i = 0; i < cfgs.length; ++i) {
            Configuration child = cfgs[i];
            try {
                if (!child.getAttribute("mime").equals(mimeType)) continue;
                userRendererConfig = child;
                break;
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
        }
        log.debug((Object)((userRendererConfig == null ? "No u" : "U") + "ser configuration found for MIME type " + mimeType));
        return userRendererConfig;
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        Configuration pageConfig;
        log.info((Object)"Initializing FopFactory Configuration");
        if (cfg.getChild("strict-configuration", false) != null) {
            this.strictUserConfigValidation = cfg.getChild("strict-configuration").getValueAsBoolean();
        }
        if (cfg.getChild("strict-validation", false) != null) {
            this.strictFOValidation = cfg.getChild("strict-validation").getValueAsBoolean();
        }
        if (cfg.getChild("base", false) != null) {
            try {
                this.setBaseURL(FopFactory.getBaseURLfromConfig(cfg, "base"));
            }
            catch (ConfigurationException e) {
                if (this.strictUserConfigValidation) {
                    throw e;
                }
                log.error((Object)e.getMessage());
            }
        }
        if (cfg.getChild("font-base", false) != null) {
            try {
                this.setFontBaseURL(FopFactory.getBaseURLfromConfig(cfg, "font-base"));
            }
            catch (ConfigurationException e) {
                if (this.strictUserConfigValidation) {
                    throw e;
                }
                log.error((Object)e.getMessage());
            }
        }
        if (cfg.getChild("hyphenation-base", false) != null) {
            try {
                this.setHyphenBaseURL(FopFactory.getBaseURLfromConfig(cfg, "hyphenation-base"));
            }
            catch (ConfigurationException e) {
                if (this.strictUserConfigValidation) {
                    throw e;
                }
                log.error((Object)e.getMessage());
            }
        }
        if (cfg.getChild("source-resolution", false) != null) {
            this.setSourceResolution(cfg.getChild("source-resolution").getValueAsFloat(72.0f));
        }
        if (cfg.getChild("target-resolution", false) != null) {
            this.setTargetResolution(cfg.getChild("target-resolution").getValueAsFloat(72.0f));
        }
        if (cfg.getChild("break-indent-inheritance", false) != null) {
            this.setBreakIndentInheritanceOnReferenceAreaBoundary(cfg.getChild("break-indent-inheritance").getValueAsBoolean());
        }
        if ((pageConfig = cfg.getChild("default-page-settings")).getAttribute("height", null) != null) {
            this.setPageHeight(pageConfig.getAttribute("height", DEFAULT_PAGE_HEIGHT));
        }
        if (pageConfig.getAttribute("width", null) != null) {
            this.setPageWidth(pageConfig.getAttribute("width", DEFAULT_PAGE_WIDTH));
        }
    }

    public static String getBaseURLfromConfig(Configuration cfg, String name) throws ConfigurationException {
        if (cfg.getChild(name, false) != null) {
            try {
                File dir;
                String cfgBasePath = cfg.getChild(name).getValue(null);
                if (cfgBasePath != null && (dir = new File(cfgBasePath)).isDirectory()) {
                    cfgBasePath = dir.toURL().toExternalForm();
                }
                log.info((Object)(name + " set to: " + cfgBasePath));
                return cfgBasePath;
            }
            catch (MalformedURLException mue) {
                throw new ConfigurationException("Base URL '" + name + "' in user config is malformed!");
            }
        }
        return null;
    }

    public void setStrictUserConfigValidation(boolean strictUserConfigValidation) {
        this.strictUserConfigValidation = strictUserConfigValidation;
    }

    public boolean validateUserConfigStrictly() {
        return this.strictUserConfigValidation;
    }

    public Source resolveURI(String uri, String base) {
        Source source = null;
        boolean bypassURIResolution = uri.startsWith("data:");
        if (!bypassURIResolution && this.uriResolver != null) {
            try {
                source = this.uriResolver.resolve(uri, base);
            }
            catch (TransformerException te) {
                log.error((Object)("Attempt to resolve URI '" + uri + "' failed: "), (Throwable)te);
            }
        }
        if (source == null) {
            try {
                source = this.foURIResolver.resolve(uri, base);
            }
            catch (TransformerException te) {
                log.error((Object)("Attempt to resolve URI '" + uri + "' failed: "), (Throwable)te);
            }
        }
        return source;
    }

    public ColorSpace getColorSpace(String base, String iccProfileSrc) {
        ColorSpace colorSpace = null;
        if (!this.colorSpaceMap.containsKey(base + iccProfileSrc)) {
            try {
                ICC_Profile iccProfile = null;
                Source src = this.resolveURI(iccProfileSrc, base);
                if (src != null && src instanceof StreamSource) {
                    iccProfile = ICC_Profile.getInstance(((StreamSource)src).getInputStream());
                }
                if (iccProfile != null) {
                    colorSpace = new ICC_ColorSpace(iccProfile);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (colorSpace != null) {
                this.colorSpaceMap.put(base + iccProfileSrc, colorSpace);
            } else {
                log.warn((Object)("Color profile '" + iccProfileSrc + "' not found."));
            }
        } else {
            colorSpace = (ColorSpace)this.colorSpaceMap.get(base + iccProfileSrc);
        }
        return colorSpace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

