/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.base14.Courier;
import org.apache.fop.fonts.base14.CourierBold;
import org.apache.fop.fonts.base14.CourierBoldOblique;
import org.apache.fop.fonts.base14.CourierOblique;
import org.apache.fop.fonts.base14.Helvetica;
import org.apache.fop.fonts.base14.HelveticaBold;
import org.apache.fop.fonts.base14.HelveticaBoldOblique;
import org.apache.fop.fonts.base14.HelveticaOblique;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.TimesBold;
import org.apache.fop.fonts.base14.TimesBoldItalic;
import org.apache.fop.fonts.base14.TimesItalic;
import org.apache.fop.fonts.base14.TimesRoman;
import org.apache.fop.fonts.base14.ZapfDingbats;
import org.apache.fop.render.PrintRenderer;

public class FontSetup {
    protected static Log log = LogFactory.getLog((String)"org.apache.fop.fonts");

    public static void setup(FontInfo fontInfo, List embedList, FontResolver resolver) {
        FontSetup.setup(fontInfo, embedList, resolver, false);
    }

    public static void setup(FontInfo fontInfo, List embedList, FontResolver resolver, boolean enableBase14Kerning) {
        fontInfo.addMetrics("F1", new Helvetica(enableBase14Kerning));
        fontInfo.addMetrics("F2", new HelveticaOblique(enableBase14Kerning));
        fontInfo.addMetrics("F3", new HelveticaBold(enableBase14Kerning));
        fontInfo.addMetrics("F4", new HelveticaBoldOblique(enableBase14Kerning));
        fontInfo.addMetrics("F5", new TimesRoman(enableBase14Kerning));
        fontInfo.addMetrics("F6", new TimesItalic(enableBase14Kerning));
        fontInfo.addMetrics("F7", new TimesBold(enableBase14Kerning));
        fontInfo.addMetrics("F8", new TimesBoldItalic(enableBase14Kerning));
        fontInfo.addMetrics("F9", new Courier(enableBase14Kerning));
        fontInfo.addMetrics("F10", new CourierOblique(enableBase14Kerning));
        fontInfo.addMetrics("F11", new CourierBold(enableBase14Kerning));
        fontInfo.addMetrics("F12", new CourierBoldOblique(enableBase14Kerning));
        fontInfo.addMetrics("F13", new Symbol());
        fontInfo.addMetrics("F14", new ZapfDingbats());
        fontInfo.addFontProperties("F5", "any", "normal", 400);
        fontInfo.addFontProperties("F6", "any", "italic", 400);
        fontInfo.addFontProperties("F6", "any", "oblique", 400);
        fontInfo.addFontProperties("F7", "any", "normal", 700);
        fontInfo.addFontProperties("F8", "any", "italic", 700);
        fontInfo.addFontProperties("F8", "any", "oblique", 700);
        fontInfo.addFontProperties("F1", "sans-serif", "normal", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "italic", 400);
        fontInfo.addFontProperties("F3", "sans-serif", "normal", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "italic", 700);
        fontInfo.addFontProperties("F5", "serif", "normal", 400);
        fontInfo.addFontProperties("F6", "serif", "oblique", 400);
        fontInfo.addFontProperties("F6", "serif", "italic", 400);
        fontInfo.addFontProperties("F7", "serif", "normal", 700);
        fontInfo.addFontProperties("F8", "serif", "oblique", 700);
        fontInfo.addFontProperties("F8", "serif", "italic", 700);
        fontInfo.addFontProperties("F9", "monospace", "normal", 400);
        fontInfo.addFontProperties("F10", "monospace", "oblique", 400);
        fontInfo.addFontProperties("F10", "monospace", "italic", 400);
        fontInfo.addFontProperties("F11", "monospace", "normal", 700);
        fontInfo.addFontProperties("F12", "monospace", "oblique", 700);
        fontInfo.addFontProperties("F12", "monospace", "italic", 700);
        fontInfo.addFontProperties("F1", "Helvetica", "normal", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "italic", 400);
        fontInfo.addFontProperties("F3", "Helvetica", "normal", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "italic", 700);
        fontInfo.addFontProperties("F5", "Times", "normal", 400);
        fontInfo.addFontProperties("F6", "Times", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times", "italic", 400);
        fontInfo.addFontProperties("F7", "Times", "normal", 700);
        fontInfo.addFontProperties("F8", "Times", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times", "italic", 700);
        fontInfo.addFontProperties("F9", "Courier", "normal", 400);
        fontInfo.addFontProperties("F10", "Courier", "oblique", 400);
        fontInfo.addFontProperties("F10", "Courier", "italic", 400);
        fontInfo.addFontProperties("F11", "Courier", "normal", 700);
        fontInfo.addFontProperties("F12", "Courier", "oblique", 700);
        fontInfo.addFontProperties("F12", "Courier", "italic", 700);
        fontInfo.addFontProperties("F13", "Symbol", "normal", 400);
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", 400);
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", 700);
        fontInfo.addFontProperties("F5", "Times Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "italic", 700);
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", 400);
        FontSetup.addConfiguredFonts(fontInfo, embedList, 15, resolver);
    }

    public static void addConfiguredFonts(FontInfo fontInfo, List fontInfoList, int num, FontResolver resolver) {
        if (fontInfoList == null) {
            return;
        }
        if (resolver == null) {
            resolver = FontSetup.createMinimalFontResolver();
        }
        String internalName = null;
        for (int i = 0; i < fontInfoList.size(); ++i) {
            EmbedFontInfo configFontInfo = (EmbedFontInfo)fontInfoList.get(i);
            String metricsFile = configFontInfo.getMetricsFile();
            internalName = "F" + num;
            ++num;
            LazyFont font = new LazyFont(configFontInfo.getEmbedFile(), metricsFile, configFontInfo.getKerning(), resolver);
            fontInfo.addMetrics(internalName, font);
            List triplets = configFontInfo.getFontTriplets();
            for (int c = 0; c < triplets.size(); ++c) {
                FontTriplet triplet = (FontTriplet)triplets.get(c);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registering: " + triplet + " under " + internalName));
                }
                fontInfo.addFontProperties(internalName, triplet);
            }
        }
    }

    private static FontResolver createMinimalFontResolver() {
        return new FontResolver(){

            public Source resolve(String href) {
                return new StreamSource(href);
            }
        };
    }

    public static List buildFontListFromConfiguration(Configuration cfg, PrintRenderer renderer) throws ConfigurationException {
        FontResolver fontResolver;
        ArrayList<EmbedFontInfo> fontList = new ArrayList<EmbedFontInfo>();
        FontResolver fontResolver2 = fontResolver = renderer != null ? renderer.getFontResolver() : null;
        if (fontResolver == null) {
            fontResolver = FontSetup.createMinimalFontResolver();
        }
        boolean strict = false;
        if (renderer != null) {
            strict = renderer.getUserAgent().getFactory().validateUserConfigStrictly();
        }
        Configuration[] fonts = cfg.getChildren("fonts");
        for (int f = 0; f < fonts.length; ++f) {
            Configuration[] font = fonts[f].getChildren("font");
            for (int i = 0; i < font.length; ++i) {
                String metricsUrl = font[i].getAttribute("metrics-url", null);
                String embedUrl = font[i].getAttribute("embed-url", null);
                if (metricsUrl == null && embedUrl == null) {
                    if (strict) {
                        throw new ConfigurationException("Font configuration without metric-url or embed-url");
                    }
                    log.error((Object)"Font configuration without metric-url or embed-url");
                    continue;
                }
                if (metricsUrl != null && fontResolver.resolve(metricsUrl) == null) {
                    if (strict) {
                        throw new ConfigurationException("Failed to resolve font metric-url '" + metricsUrl + "'");
                    }
                    log.error((Object)("Failed to resolve font metric-url '" + metricsUrl + "'"));
                    continue;
                }
                if (embedUrl != null && fontResolver.resolve(embedUrl) == null) {
                    if (strict) {
                        throw new ConfigurationException("Failed to resolve font with embed-url '" + embedUrl + "'");
                    }
                    log.error((Object)("Failed to resolve font with embed-url '" + embedUrl + "'"));
                    continue;
                }
                boolean useKerning = font[i].getAttributeAsBoolean("kerning", false);
                Configuration[] triple = font[i].getChildren("font-triplet");
                ArrayList<FontTriplet> tripleList = new ArrayList<FontTriplet>();
                for (int j = 0; j < triple.length; ++j) {
                    String name = triple[j].getAttribute("name");
                    if (name == null) {
                        if (strict) {
                            throw new ConfigurationException("font-triplet without name");
                        }
                        log.error((Object)"font-triplet without name");
                        continue;
                    }
                    String weightStr = triple[j].getAttribute("weight");
                    if (weightStr == null) {
                        if (strict) {
                            throw new ConfigurationException("font-triplet without weight");
                        }
                        log.error((Object)"font-triplet without weight");
                        continue;
                    }
                    int weight = FontUtil.parseCSS2FontWeight(weightStr);
                    String style = triple[j].getAttribute("style");
                    if (style == null) {
                        if (strict) {
                            throw new ConfigurationException("font-triplet without style");
                        }
                        log.error((Object)"font-triplet without style");
                        continue;
                    }
                    tripleList.add(FontInfo.createFontKey(name, style, weight));
                }
                EmbedFontInfo configFontInfo = new EmbedFontInfo(metricsUrl, useKerning, tripleList, embedUrl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding font " + configFontInfo.getEmbedFile() + ", metric file " + configFontInfo.getMetricsFile()));
                    for (int j = 0; j < tripleList.size(); ++j) {
                        FontTriplet triplet = (FontTriplet)tripleList.get(j);
                        log.debug((Object)("Font triplet " + triplet.getName() + ", " + triplet.getStyle() + ", " + triplet.getWeight()));
                    }
                }
                fontList.add(configFontInfo);
            }
        }
        return fontList;
    }

    public static List buildFontListFromConfiguration(Configuration cfg) throws ConfigurationException {
        return FontSetup.buildFontListFromConfiguration(cfg, null);
    }
}

