/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.fop.fonts.BFEntry;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFCmapEntry;
import org.apache.fop.fonts.truetype.TTFFile;

public class TTFFontLoader
extends FontLoader {
    private String fontFileURI;
    private TTFFile ttf;
    private MultiByteFont multiFont;
    private CustomFont returnFont;
    private FontResolver resolver;

    public TTFFontLoader(String fontFileURI, InputStream in, FontResolver resolver) throws IOException {
        this.fontFileURI = fontFileURI;
        this.resolver = resolver;
        this.ttf = new TTFFile();
        FontFileReader reader = new FontFileReader(in);
        boolean supported = this.ttf.readFont(reader, null);
        if (!supported) {
            throw new IOException("Could not load TrueType font: " + fontFileURI);
        }
        if (this.ttf.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF data are not supported, yet");
        }
        this.multiFont = new MultiByteFont();
        this.multiFont.setResolver(this.resolver);
        this.returnFont = this.multiFont;
        this.read();
    }

    private void read() throws IOException {
        this.returnFont.setFontName(this.ttf.getFamilyName());
        this.returnFont.setCapHeight(this.ttf.getCapHeight());
        this.returnFont.setXHeight(this.ttf.getXHeight());
        this.returnFont.setAscender(this.ttf.getLowerCaseAscent());
        this.returnFont.setDescender(this.ttf.getLowerCaseDescent());
        this.returnFont.setFontBBox(this.ttf.getFontBBox());
        this.returnFont.setFlags(this.ttf.getFlags());
        this.returnFont.setStemV(Integer.parseInt(this.ttf.getStemV()));
        this.returnFont.setItalicAngle(Integer.parseInt(this.ttf.getItalicAngle()));
        this.returnFont.setMissingWidth(0);
        this.multiFont.setCIDType(CIDFontType.CIDTYPE2);
        int[] wx = this.ttf.getWidths();
        this.multiFont.setWidthArray(wx);
        List entries = this.ttf.getCMaps();
        BFEntry[] bfentries = new BFEntry[entries.size()];
        int pos = 0;
        ListIterator iter = this.ttf.getCMaps().listIterator();
        while (iter.hasNext()) {
            TTFCmapEntry ce = (TTFCmapEntry)iter.next();
            bfentries[pos] = new BFEntry(ce.getUnicodeStart(), ce.getUnicodeEnd(), ce.getGlyphStartIndex());
            ++pos;
        }
        this.multiFont.setBFEntries(bfentries);
        this.copyKerning(this.ttf, true);
        this.multiFont.setEmbedFileName(this.fontFileURI);
    }

    private void copyKerning(TTFFile ttf, boolean isCid) {
        Iterator iter = isCid ? ttf.getKerning().keySet().iterator() : ttf.getAnsiKerning().keySet().iterator();
        while (iter.hasNext()) {
            Integer kpx1 = (Integer)iter.next();
            Map h2 = isCid ? (Map)ttf.getKerning().get(kpx1) : (Map)ttf.getAnsiKerning().get(kpx1);
            this.returnFont.putKerningEntry(kpx1, h2);
        }
    }

    public CustomFont getFont() {
        return this.returnFont;
    }
}

