/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.MinOptMaxUtil;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.EmptyGridUnit;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.GridUnitPart;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableHeaderFooterPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.layoutmgr.table.TableRowIterator;
import org.apache.fop.layoutmgr.table.TableStepper;
import org.apache.fop.traits.MinOptMax;

public class TableContentLayoutManager
implements PercentBaseContext {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$table$TableContentLayoutManager == null ? (class$org$apache$fop$layoutmgr$table$TableContentLayoutManager = TableContentLayoutManager.class$("org.apache.fop.layoutmgr.table.TableContentLayoutManager")) : class$org$apache$fop$layoutmgr$table$TableContentLayoutManager));
    private TableLayoutManager tableLM;
    private TableRowIterator bodyIter;
    private TableRowIterator headerIter;
    private TableRowIterator footerIter;
    private LinkedList headerList;
    private LinkedList footerList;
    private int headerNetHeight = 0;
    private int footerNetHeight = 0;
    private int startXOffset;
    private int usedBPD;
    private TableStepper stepper = new TableStepper(this);
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableContentLayoutManager;

    public TableContentLayoutManager(TableLayoutManager parent) {
        this.tableLM = parent;
        Table table = this.getTableLM().getTable();
        this.bodyIter = new TableRowIterator(table, this.getTableLM().getColumns(), 0);
        if (table.getTableHeader() != null) {
            this.headerIter = new TableRowIterator(table, this.getTableLM().getColumns(), 1);
        }
        if (table.getTableFooter() != null) {
            this.footerIter = new TableRowIterator(table, this.getTableLM().getColumns(), 2);
        }
    }

    public TableLayoutManager getTableLM() {
        return this.tableLM;
    }

    boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    public ColumnSetup getColumns() {
        return this.getTableLM().getColumns();
    }

    protected int getHeaderNetHeight() {
        return this.headerNetHeight;
    }

    protected int getFooterNetHeight() {
        return this.footerNetHeight;
    }

    protected LinkedList getHeaderElements() {
        return this.headerList;
    }

    protected LinkedList getFooterElements() {
        return this.footerList;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        KnuthBox box;
        TableHeaderFooterPosition pos;
        log.debug((Object)("==> Columns: " + this.getTableLM().getColumns()));
        KnuthBox headerAsFirst = null;
        KnuthBox headerAsSecondToLast = null;
        KnuthBox footerAsLast = null;
        if (this.headerIter != null && this.headerList == null) {
            this.headerList = this.getKnuthElementsForRowIterator(this.headerIter, context, alignment, 1);
            ElementListUtils.removeLegalBreaks(this.headerList);
            this.headerNetHeight = ElementListUtils.calcContentLength(this.headerList);
            if (log.isDebugEnabled()) {
                log.debug((Object)("==> Header: " + this.headerNetHeight + " - " + this.headerList));
            }
            pos = new TableHeaderFooterPosition(this.getTableLM(), true, this.headerList);
            box = new KnuthBox(this.headerNetHeight, pos, false);
            if (this.getTableLM().getTable().omitHeaderAtBreak()) {
                headerAsFirst = box;
            } else {
                headerAsSecondToLast = box;
            }
        }
        if (this.footerIter != null && this.footerList == null) {
            this.footerList = this.getKnuthElementsForRowIterator(this.footerIter, context, alignment, 2);
            ElementListUtils.removeLegalBreaks(this.footerList);
            this.footerNetHeight = ElementListUtils.calcContentLength(this.footerList);
            if (log.isDebugEnabled()) {
                log.debug((Object)("==> Footer: " + this.footerNetHeight + " - " + this.footerList));
            }
            pos = new TableHeaderFooterPosition(this.getTableLM(), false, this.footerList);
            footerAsLast = box = new KnuthBox(this.footerNetHeight, pos, false);
        }
        LinkedList returnList = this.getKnuthElementsForRowIterator(this.bodyIter, context, alignment, 0);
        if (headerAsFirst != null) {
            int insertionPoint = 0;
            if (returnList.size() > 0 && ((ListElement)returnList.getFirst()).isForcedBreak()) {
                ++insertionPoint;
            }
            returnList.add(insertionPoint, headerAsFirst);
        } else if (headerAsSecondToLast != null) {
            int insertionPoint = returnList.size();
            if (returnList.size() > 0 && ((ListElement)returnList.getLast()).isForcedBreak()) {
                --insertionPoint;
            }
            returnList.add(insertionPoint, headerAsSecondToLast);
        }
        if (footerAsLast != null) {
            int insertionPoint = returnList.size();
            if (returnList.size() > 0 && ((ListElement)returnList.getLast()).isForcedBreak()) {
                --insertionPoint;
            }
            returnList.add(insertionPoint, footerAsLast);
        }
        return returnList;
    }

    private LinkedList getKnuthElementsForRowIterator(TableRowIterator iter, LayoutContext context, int alignment, int bodyType) {
        int orphanContentLimit;
        int widowContentLimit;
        ListElement last;
        LinkedList<BreakElement> returnList = new LinkedList<BreakElement>();
        EffRow[] rowGroup = null;
        while ((rowGroup = iter.getNextRowGroup()) != null) {
            BreakElement breakPoss;
            KnuthPenalty pen;
            ListElement last2;
            TableRow rowFO = rowGroup[0].getTableRow();
            if (rowFO != null && rowFO.getBreakBefore() != 9) {
                log.info((Object)"break-before found");
                if (returnList.size() > 0) {
                    last2 = (ListElement)returnList.getLast();
                    if (last2.isPenalty()) {
                        pen = (KnuthPenalty)last2;
                        pen.setP(-1000);
                        pen.setBreakClass(rowFO.getBreakBefore());
                    } else {
                        breakPoss = (BreakElement)last2;
                        breakPoss.setPenaltyValue(-1000);
                        breakPoss.setBreakClass(rowFO.getBreakBefore());
                    }
                } else {
                    returnList.add(new BreakElement(new Position(this.getTableLM()), 0, -1000, rowFO.getBreakBefore(), context));
                }
            }
            if (!this.isSeparateBorderModel()) {
                this.resolveNormalBeforeAfterBordersForRowGroup(rowGroup, iter);
            }
            context.setFlags(512, false);
            this.createElementsForRowGroup(context, alignment, bodyType, returnList, rowGroup);
            if (context.isKeepWithNextPending()) {
                log.debug((Object)"child LM (row group) signals pending keep-with-next");
            }
            if (context.isKeepWithPreviousPending()) {
                log.debug((Object)"child LM (row group) signals pending keep-with-previous");
                if (returnList.size() > 0 && (last2 = (ListElement)returnList.getLast()).isPenalty() && !(breakPoss = (BreakElement)last2).isForcedBreak()) {
                    breakPoss.setPenaltyValue(1000);
                }
            }
            if ((rowFO = rowGroup[rowGroup.length - 1].getTableRow()) == null || rowFO.getBreakAfter() == 9 || returnList.size() <= 0) continue;
            last2 = (ListElement)returnList.getLast();
            if (last2 instanceof KnuthPenalty) {
                pen = (KnuthPenalty)last2;
                pen.setP(-1000);
                pen.setBreakClass(rowFO.getBreakAfter());
                continue;
            }
            if (!(last2 instanceof BreakElement)) continue;
            breakPoss = (BreakElement)last2;
            breakPoss.setPenaltyValue(-1000);
            breakPoss.setBreakClass(rowFO.getBreakAfter());
        }
        if (returnList.size() > 0 && ((last = (ListElement)returnList.getLast()).isPenalty() || last instanceof BreakElement) && !last.isForcedBreak()) {
            returnList.removeLast();
        }
        if ((widowContentLimit = this.getTableLM().getTable().getWidowContentLimit().getValue()) != 0 && bodyType == 0) {
            ElementListUtils.removeLegalBreaks(returnList, widowContentLimit);
        }
        if ((orphanContentLimit = this.getTableLM().getTable().getOrphanContentLimit().getValue()) != 0 && bodyType == 0) {
            ElementListUtils.removeLegalBreaksFromEnd(returnList, orphanContentLimit);
        }
        return returnList;
    }

    private void resolveNormalBeforeAfterBordersForRowGroup(EffRow[] rowGroup, TableRowIterator iter) {
        for (int rgi = 0; rgi < rowGroup.length; ++rgi) {
            int i;
            EffRow row = rowGroup[rgi];
            EffRow prevRow = iter.getPrecedingRow(row);
            EffRow nextRow = iter.getFollowingRow(row);
            if (prevRow == null && iter == this.bodyIter && this.headerIter != null) {
                prevRow = this.headerIter.getLastRow();
            }
            if (nextRow == null && iter == this.headerIter) {
                nextRow = this.bodyIter.getFirstRow();
            }
            if (nextRow == null && iter == this.bodyIter && this.footerIter != null) {
                nextRow = this.footerIter.getFirstRow();
            }
            if (prevRow == null && iter == this.footerIter) {
                prevRow = this.bodyIter.getLastRow();
            }
            log.debug((Object)("prevRow-row-nextRow: " + prevRow + " - " + row + " - " + nextRow));
            int guCount = row.getGridUnits().size();
            if (prevRow != null) {
                guCount = Math.max(guCount, prevRow.getGridUnits().size());
            }
            if (nextRow != null) {
                guCount = Math.max(guCount, nextRow.getGridUnits().size());
            }
            GridUnit gu = row.getGridUnit(0);
            for (i = 0; i < guCount - row.getGridUnits().size(); ++i) {
                int pos = row.getGridUnits().size() + i;
                row.getGridUnits().add(new EmptyGridUnit(gu.getRow(), this.tableLM.getColumns().getColumn(pos + 1), gu.getBody(), pos));
            }
            if (this.getTableLM().getTable().isSeparateBorderModel()) continue;
            for (i = 0; i < row.getGridUnits().size(); ++i) {
                gu = row.getGridUnit(i);
                int flags = 0;
                GridUnit other = prevRow != null && i < prevRow.getGridUnits().size() ? prevRow.getGridUnit(i) : null;
                if (other == null || other.isEmpty() || gu.isEmpty() || gu.getPrimary() != other.getPrimary()) {
                    if (iter == this.bodyIter && gu.getFlag(2) && this.headerIter == null) {
                        flags |= 1;
                    }
                    if (iter == this.headerIter && gu.getFlag(2)) {
                        flags |= 1;
                    }
                    gu.resolveBorder(other, 0, flags);
                }
                flags = 0;
                other = nextRow != null && i < nextRow.getGridUnits().size() ? nextRow.getGridUnit(i) : null;
                if (other != null && !other.isEmpty() && !gu.isEmpty() && gu.getPrimary() == other.getPrimary()) continue;
                if (iter == this.bodyIter && gu.getFlag(5) && this.footerIter == null) {
                    flags |= 1;
                }
                if (iter == this.footerIter && gu.getFlag(5)) {
                    flags |= 1;
                }
                gu.resolveBorder(other, 1, flags);
            }
        }
    }

    private void createElementsForRowGroup(LayoutContext context, int alignment, int bodyType, LinkedList returnList, EffRow[] rowGroup) {
        LinkedList returnedList;
        log.debug((Object)("Handling row group with " + rowGroup.length + " rows..."));
        MinOptMax[] rowHeights = new MinOptMax[rowGroup.length];
        MinOptMax[] explicitRowHeights = new MinOptMax[rowGroup.length];
        int maxColumnCount = 0;
        ArrayList<PrimaryGridUnit> pgus = new ArrayList<PrimaryGridUnit>();
        for (int rgi = 0; rgi < rowGroup.length; ++rgi) {
            EffRow row = rowGroup[rgi];
            rowHeights[rgi] = new MinOptMax(0, 0, Integer.MAX_VALUE);
            explicitRowHeights[rgi] = new MinOptMax(0, 0, Integer.MAX_VALUE);
            pgus.clear();
            TableRow tableRow = null;
            int minContentHeight = 0;
            int maxCellHeight = 0;
            int effRowContentHeight = 0;
            for (int j = 0; j < row.getGridUnits().size(); ++j) {
                maxColumnCount = Math.max(maxColumnCount, row.getGridUnits().size());
                GridUnit gu = row.getGridUnit(j);
                if (!gu.isPrimary() && (gu.getColSpanIndex() != 0 || !gu.isLastGridUnitRowSpan()) || gu.isEmpty()) continue;
                PrimaryGridUnit primary = gu.getPrimary();
                if (gu.isPrimary()) {
                    primary.getCellLM().setParent(this.getTableLM());
                    if (tableRow == null && primary.getRow() != null) {
                        tableRow = primary.getRow();
                        LengthRangeProperty bpd = tableRow.getBlockProgressionDimension();
                        if (!bpd.getMinimum(this.getTableLM()).isAuto()) {
                            minContentHeight = Math.max(minContentHeight, bpd.getMinimum(this.getTableLM()).getLength().getValue(this.getTableLM()));
                        }
                        MinOptMaxUtil.restrict(explicitRowHeights[rgi], bpd, this.getTableLM());
                    }
                    int spanWidth = 0;
                    for (int i = primary.getStartCol(); i < primary.getStartCol() + primary.getCell().getNumberColumnsSpanned(); ++i) {
                        if (this.getTableLM().getColumns().getColumn(i + 1) == null) continue;
                        spanWidth += this.getTableLM().getColumns().getColumn(i + 1).getColumnWidth().getValue(this.getTableLM());
                    }
                    LayoutContext childLC = new LayoutContext(0);
                    childLC.setStackLimit(context.getStackLimit());
                    childLC.setRefIPD(spanWidth);
                    LinkedList elems = primary.getCellLM().getNextKnuthElements(childLC, alignment);
                    while (!primary.getCellLM().isFinished()) {
                        LinkedList additionalElems = primary.getCellLM().getNextKnuthElements(childLC, alignment);
                        elems.addAll(additionalElems);
                    }
                    ElementListObserver.observe(elems, "table-cell", primary.getCell().getId());
                    if (elems.size() > 0 && ((KnuthElement)elems.getLast()).isForcedBreak()) {
                        log.debug((Object)("Descendant of table-cell signals break: " + primary.getCellLM().isFinished()));
                    }
                    primary.setElements(elems);
                    if (childLC.isKeepWithNextPending()) {
                        log.debug((Object)"child LM signals pending keep-with-next");
                        primary.setFlag(6, true);
                    }
                    if (childLC.isKeepWithPreviousPending()) {
                        log.debug((Object)"child LM signals pending keep-with-previous");
                        primary.setFlag(7, true);
                    }
                }
                primary.setContentLength(ElementListUtils.calcContentLength(primary.getElements()));
                maxCellHeight = Math.max(maxCellHeight, primary.getContentLength());
                if (gu.isLastGridUnitRowSpan()) {
                    int effCellContentHeight = minContentHeight;
                    LengthRangeProperty bpd = primary.getCell().getBlockProgressionDimension();
                    if (!bpd.getMinimum(this.getTableLM()).isAuto()) {
                        effCellContentHeight = Math.max(effCellContentHeight, bpd.getMinimum(this.getTableLM()).getLength().getValue(this.getTableLM()));
                    }
                    if (!bpd.getOptimum(this.getTableLM()).isAuto()) {
                        effCellContentHeight = Math.max(effCellContentHeight, bpd.getOptimum(this.getTableLM()).getLength().getValue(this.getTableLM()));
                    }
                    if (gu.getRowSpanIndex() == 0) {
                        MinOptMaxUtil.restrict(explicitRowHeights[rgi], bpd, this.tableLM);
                    }
                    effCellContentHeight = Math.max(effCellContentHeight, primary.getContentLength());
                    int borderWidths = this.isSeparateBorderModel() ? primary.getBorders().getBorderBeforeWidth(false) + primary.getBorders().getBorderAfterWidth(false) : primary.getHalfMaxBorderWidth();
                    int padding = 0;
                    effRowContentHeight = Math.max(effRowContentHeight, effCellContentHeight);
                    CommonBorderPaddingBackground cbpb = primary.getCell().getCommonBorderPaddingBackground();
                    padding += cbpb.getPaddingBefore(false, primary.getCellLM());
                    int effRowHeight = effCellContentHeight + (padding += cbpb.getPaddingAfter(false, primary.getCellLM())) + borderWidths + 2 * this.getTableLM().getHalfBorderSeparationBPD();
                    for (int previous = 0; previous < gu.getRowSpanIndex(); ++previous) {
                        effRowHeight -= rowHeights[rgi - previous - 1].opt;
                    }
                    if (effRowHeight > rowHeights[rgi].min) {
                        MinOptMaxUtil.extendMinimum(rowHeights[rgi], effRowHeight, false);
                    }
                }
                if (!gu.isPrimary()) continue;
                pgus.add(primary);
            }
            row.setHeight(rowHeights[rgi]);
            row.setExplicitHeight(explicitRowHeights[rgi]);
            if (effRowContentHeight <= row.getExplicitHeight().max) continue;
            log.warn((Object)FONode.decorateWithContextInfo("The contents of row " + (row.getIndex() + 1) + " are taller than they should be (there is a" + " block-progression-dimension or height constraint on the indicated row)." + " Due to its contents the row grows" + " to " + effRowContentHeight + " millipoints, but the row shouldn't get" + " any taller than " + row.getExplicitHeight() + " millipoints.", row.getTableRow()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"rowGroup:");
            for (int i = 0; i < rowHeights.length; ++i) {
                log.debug((Object)("  height=" + rowHeights[i] + " explicit=" + explicitRowHeights[i]));
            }
        }
        if ((returnedList = this.stepper.getCombinedKnuthElementsForRowGroup(context, rowGroup, maxColumnCount, bodyType)) != null) {
            returnList.addAll(returnedList);
        }
    }

    protected int getXOffsetOfGridUnit(GridUnit gu) {
        int col = gu.getStartCol();
        return this.startXOffset + this.getTableLM().getColumns().getXOffset(col + 1, this.getTableLM());
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        Map markers;
        this.usedBPD = 0;
        RowPainter painter = new RowPainter(this, layoutContext);
        ArrayList<Position> positions = new ArrayList<Position>();
        List headerElements = null;
        List footerElements = null;
        int nestedPenaltyArea = 0;
        Position firstPos = null;
        Position lastPos = null;
        Position lastCheckPos = null;
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos instanceof SpaceResolver.SpaceHandlingBreakPosition) {
                pos = ((SpaceResolver.SpaceHandlingBreakPosition)pos).getOriginalBreakPosition();
            }
            if (pos == null) continue;
            if (firstPos == null) {
                firstPos = pos;
            }
            lastPos = pos;
            if (pos.getIndex() >= 0) {
                lastCheckPos = pos;
            }
            if (pos instanceof TableHeaderFooterPosition) {
                TableHeaderFooterPosition thfpos = (TableHeaderFooterPosition)pos;
                if (thfpos.header) {
                    headerElements = thfpos.nestedElements;
                    continue;
                }
                footerElements = thfpos.nestedElements;
                continue;
            }
            if (pos instanceof TableHFPenaltyPosition) continue;
            positions.add(pos);
        }
        if (lastPos instanceof TableHFPenaltyPosition) {
            TableHFPenaltyPosition penaltyPos = (TableHFPenaltyPosition)lastPos;
            log.debug((Object)"Break at penalty!");
            if (penaltyPos.headerElements != null) {
                headerElements = penaltyPos.headerElements;
            }
            if (penaltyPos.footerElements != null) {
                footerElements = penaltyPos.footerElements;
            }
            nestedPenaltyArea = penaltyPos.nestedPenaltyLength;
        }
        if ((markers = this.getTableLM().getTable().getMarkers()) != null) {
            this.getTableLM().getCurrentPV().addMarkers(markers, true, this.getTableLM().isFirst(firstPos), this.getTableLM().isLast(lastCheckPos));
        }
        if (headerElements != null) {
            KnuthPossPosIter nestedIter = new KnuthPossPosIter(headerElements);
            this.iterateAndPaintPositions(nestedIter, painter);
        }
        Iterator posIter = positions.iterator();
        this.iterateAndPaintPositions(posIter, painter);
        painter.notifyNestedPenaltyArea(nestedPenaltyArea);
        if (footerElements != null) {
            KnuthPossPosIter nestedIter = new KnuthPossPosIter(footerElements);
            this.iterateAndPaintPositions(nestedIter, painter);
        }
        this.usedBPD += painter.getAccumulatedBPD();
        if (markers != null) {
            this.getTableLM().getCurrentPV().addMarkers(markers, false, this.getTableLM().isFirst(firstPos), this.getTableLM().isLast(lastCheckPos));
        }
    }

    private void iterateAndPaintPositions(Iterator iterator, RowPainter painter) {
        ArrayList<TableContentPosition> lst = new ArrayList<TableContentPosition>();
        boolean firstPos = false;
        TableBody body = null;
        while (iterator.hasNext()) {
            Position pos = (Position)iterator.next();
            if (pos instanceof TableContentPosition) {
                TableContentPosition tcpos = (TableContentPosition)pos;
                lst.add(tcpos);
                GridUnitPart part = (GridUnitPart)tcpos.gridUnitParts.get(0);
                if (body == null) {
                    body = part.pgu.getBody();
                }
                if (tcpos.getFlag(1) && tcpos.row.getFlag(3)) {
                    firstPos = true;
                }
                if (!tcpos.getFlag(2) || !tcpos.row.getFlag(4)) continue;
                log.trace((Object)"LAST_IN_ROWGROUP + LAST_IN_PART");
                this.handleMarkersAndPositions(lst, body, firstPos, true, painter);
                firstPos = false;
                body = null;
                lst.clear();
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignoring position: " + pos));
        }
        if (body != null) {
            this.handleMarkersAndPositions(lst, body, firstPos, false, painter);
        }
        painter.addAreasAndFlushRow(true);
    }

    private void handleMarkersAndPositions(List positions, TableBody body, boolean firstPos, boolean lastPos, RowPainter painter) {
        this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), true, firstPos, lastPos);
        int size = positions.size();
        for (int i = 0; i < size; ++i) {
            painter.handleTableContentPosition((TableContentPosition)positions.get(i));
        }
        this.getTableLM().getCurrentPV().addMarkers(body.getMarkers(), false, firstPos, lastPos);
    }

    public Block getRowArea(TableRow row) {
        if (row == null || !row.getCommonBorderPaddingBackground().hasBackground()) {
            return null;
        }
        Block block = new Block();
        block.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
        block.setPositioning(2);
        return block;
    }

    public void addRowBackgroundArea(TableRow row, int bpd, int ipd, int yoffset) {
        Block rowBackground = this.getRowArea(row);
        if (rowBackground != null) {
            rowBackground.setBPD(bpd);
            rowBackground.setIPD(ipd);
            rowBackground.setXOffset(this.startXOffset);
            rowBackground.setYOffset(yoffset);
            this.getTableLM().addChildArea(rowBackground);
            TraitSetter.addBackground(rowBackground, row.getCommonBorderPaddingBackground(), this.getTableLM());
        }
    }

    public void setStartXOffset(int startXOffset) {
        this.startXOffset = startXOffset;
    }

    public int getUsedBPD() {
        return this.usedBPD;
    }

    public int getBaseLength(int lengthBase, FObj fobj) {
        return this.tableLM.getBaseLength(lengthBase, fobj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

