/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.GridUnitPart;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class TableStepper {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$table$TableStepper == null ? (class$org$apache$fop$layoutmgr$table$TableStepper = TableStepper.class$("org.apache.fop.layoutmgr.table.TableStepper")) : class$org$apache$fop$layoutmgr$table$TableStepper));
    private TableContentLayoutManager tclm;
    private EffRow[] rowGroup;
    private int columnCount;
    private int totalHeight;
    private int activeRowIndex;
    private List[] elementLists;
    private int[] startRow;
    private int[] start;
    private int[] end;
    private int[] widths;
    private int[] baseWidth;
    private int[] borderBefore;
    private int[] paddingBefore;
    private int[] borderAfter;
    private int[] paddingAfter;
    private boolean rowBacktrackForLastStep;
    private boolean skippedStep;
    private boolean[] keepWithNextSignals;
    private int lastMaxPenaltyLength;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableStepper;

    public TableStepper(TableContentLayoutManager tclm) {
        this.tclm = tclm;
    }

    private void setup(int columnCount) {
        this.columnCount = columnCount;
        this.activeRowIndex = 0;
        this.elementLists = new List[columnCount];
        this.startRow = new int[columnCount];
        this.start = new int[columnCount];
        this.end = new int[columnCount];
        this.widths = new int[columnCount];
        this.baseWidth = new int[columnCount];
        this.borderBefore = new int[columnCount];
        this.paddingBefore = new int[columnCount];
        this.borderAfter = new int[columnCount];
        this.paddingAfter = new int[columnCount];
        this.keepWithNextSignals = new boolean[columnCount];
        Arrays.fill(this.end, -1);
    }

    private EffRow getActiveRow() {
        return this.rowGroup[this.activeRowIndex];
    }

    private GridUnit getActiveGridUnit(int column) {
        return this.getActiveRow().safelyGetGridUnit(column);
    }

    private PrimaryGridUnit getActivePrimaryGridUnit(int column) {
        GridUnit gu = this.getActiveGridUnit(column);
        if (gu == null) {
            return null;
        }
        return gu.getPrimary();
    }

    private void calcTotalHeight() {
        this.totalHeight = 0;
        for (int i = 0; i < this.rowGroup.length; ++i) {
            this.totalHeight += this.rowGroup[i].getHeight().opt;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("totalHeight=" + this.totalHeight));
        }
    }

    private int getMaxRemainingHeight() {
        int i;
        int maxW = 0;
        if (!this.rowBacktrackForLastStep) {
            for (i = 0; i < this.columnCount; ++i) {
                GridUnit gu;
                if (this.elementLists[i] == null || this.end[i] == this.elementLists[i].size() - 1 || !(gu = this.getActiveGridUnit(i)).isLastGridUnitRowSpan()) continue;
                int len = this.widths[i];
                if (len > 0) {
                    len += 2 * this.getTableLM().getHalfBorderSeparationBPD();
                    len += this.borderBefore[i] + this.borderAfter[i];
                    len += this.paddingBefore[i] + this.paddingAfter[i];
                }
                int nominalHeight = this.rowGroup[this.activeRowIndex].getHeight().opt;
                for (int r = 0; r < gu.getRowSpanIndex(); ++r) {
                    nominalHeight += this.rowGroup[this.activeRowIndex - r - 1].getHeight().opt;
                }
                if (len == nominalHeight) {
                    maxW = 0;
                    break;
                }
                maxW = Math.max(maxW, nominalHeight - len);
            }
        }
        for (i = this.activeRowIndex + 1; i < this.rowGroup.length; ++i) {
            maxW += this.rowGroup[i].getHeight().opt;
        }
        log.debug((Object)("maxRemainingHeight=" + maxW));
        return maxW;
    }

    private void setupElementList(int column) {
        GridUnit gu = this.getActiveGridUnit(column);
        EffRow row = this.getActiveRow();
        if (gu == null || gu.isEmpty()) {
            this.elementLists[column] = null;
            this.start[column] = 0;
            this.end[column] = -1;
            this.widths[column] = 0;
            this.startRow[column] = this.activeRowIndex;
            this.keepWithNextSignals[column] = false;
        } else if (gu.isPrimary()) {
            boolean contentsSmaller;
            PrimaryGridUnit pgu = (PrimaryGridUnit)gu;
            boolean makeBoxForWholeRow = false;
            if (row.getExplicitHeight().min > 0 && (contentsSmaller = ElementListUtils.removeLegalBreaks(pgu.getElements(), row.getExplicitHeight()))) {
                makeBoxForWholeRow = true;
            }
            if (pgu.isLastGridUnitRowSpan() && pgu.getRow() != null) {
                makeBoxForWholeRow |= pgu.getRow().mustKeepTogether();
                makeBoxForWholeRow |= pgu.getTable().mustKeepTogether();
            }
            if (makeBoxForWholeRow) {
                ArrayList<KnuthBoxCellWithBPD> list = new ArrayList<KnuthBoxCellWithBPD>(1);
                int height = row.getExplicitHeight().opt;
                if (height == 0) {
                    height = row.getHeight().opt;
                }
                list.add(new KnuthBoxCellWithBPD(height));
                this.elementLists[column] = list;
            } else {
                this.elementLists[column] = new ArrayList(pgu.getElements());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("column " + (column + 1) + ": recording " + this.elementLists[column].size() + " element(s)"));
                }
            }
            if (this.isSeparateBorderModel()) {
                this.borderBefore[column] = pgu.getBorders().getBorderBeforeWidth(false);
            } else {
                this.borderBefore[column] = pgu.getBorders().getBorderBeforeWidth(false) / 2;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("border before for column " + column + ": " + this.borderBefore[column]));
                }
            }
            this.paddingBefore[column] = pgu.getBorders().getPaddingBefore(false, pgu.getCellLM());
            this.paddingAfter[column] = pgu.getBorders().getPaddingAfter(false, pgu.getCellLM());
            this.start[column] = 0;
            this.end[column] = -1;
            this.widths[column] = 0;
            this.startRow[column] = this.activeRowIndex;
            this.keepWithNextSignals[column] = false;
        }
    }

    private void initializeElementLists() {
        log.trace((Object)"Entering initializeElementLists()");
        for (int i = 0; i < this.start.length; ++i) {
            this.setupElementList(i);
        }
    }

    public LinkedList getCombinedKnuthElementsForRowGroup(LayoutContext context, EffRow[] rowGroup, int maxColumnCount, int bodyType) {
        int step;
        this.rowGroup = rowGroup;
        this.setup(maxColumnCount);
        this.initializeElementLists();
        this.calcTotalHeight();
        boolean signalKeepWithNext = false;
        int laststep = 0;
        int addedBoxLen = 0;
        TableContentPosition lastTCPos = null;
        LinkedList<ListElement> returnList = new LinkedList<ListElement>();
        while ((step = this.getNextStep()) >= 0) {
            int normalRow = this.activeRowIndex--;
            if (this.rowBacktrackForLastStep) {
                // empty if block
            }
            int increase = step - laststep;
            int penaltyLen = step + this.getMaxRemainingHeight() - this.totalHeight;
            int boxLen = step - addedBoxLen - penaltyLen;
            addedBoxLen += boxLen;
            boolean forcedBreak = false;
            int breakClass = -1;
            ArrayList<GridUnitPart> gridUnitParts = new ArrayList<GridUnitPart>(maxColumnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.end[i] < this.start[i]) continue;
                PrimaryGridUnit pgu = rowGroup[this.startRow[i]].getGridUnit(i).getPrimary();
                if (this.start[i] == 0 && this.end[i] == 0 && this.elementLists[i].size() == 1 && this.elementLists[i].get(0) instanceof KnuthBoxCellWithBPD) {
                    gridUnitParts.add(new GridUnitPart(pgu, 0, pgu.getElements().size() - 1));
                } else {
                    gridUnitParts.add(new GridUnitPart(pgu, this.start[i], this.end[i]));
                    if (((KnuthElement)this.elementLists[i].get(this.end[i])).isForcedBreak()) {
                        forcedBreak = true;
                        breakClass = ((KnuthPenalty)this.elementLists[i].get(this.end[i])).getBreakClass();
                    }
                }
                if (this.end[i] + 1 == this.elementLists[i].size()) {
                    if (pgu.getFlag(6)) {
                        log.debug((Object)"PGU has pending keep-with-next");
                        this.keepWithNextSignals[i] = true;
                    }
                    if (pgu.getRow() != null && pgu.getRow().mustKeepWithNext()) {
                        log.debug((Object)"table-row causes keep-with-next");
                        this.keepWithNextSignals[i] = true;
                    }
                }
                if (this.start[i] != 0 || this.end[i] < 0) continue;
                if (pgu.getFlag(7)) {
                    log.debug((Object)"PGU has pending keep-with-previous");
                    if (returnList.size() == 0) {
                        context.setFlags(1024);
                    }
                }
                if (pgu.getRow() == null || !pgu.getRow().mustKeepWithPrevious()) continue;
                log.debug((Object)"table-row causes keep-with-previous");
                if (returnList.size() != 0) continue;
                context.setFlags(1024);
            }
            int effPenaltyLen = penaltyLen;
            TableContentPosition tcpos = new TableContentPosition(this.getTableLM(), gridUnitParts, rowGroup[normalRow]);
            if (returnList.size() == 0) {
                tcpos.setFlag(1, true);
            }
            lastTCPos = tcpos;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" - backtrack=" + this.rowBacktrackForLastStep + " - row=" + this.activeRowIndex + " - " + tcpos));
            }
            returnList.add(new KnuthBox(boxLen, tcpos, false));
            TableHFPenaltyPosition penaltyPos = new TableHFPenaltyPosition(this.getTableLM());
            if (bodyType == 0) {
                if (!this.getTableLM().getTable().omitHeaderAtBreak()) {
                    effPenaltyLen += this.tclm.getHeaderNetHeight();
                    penaltyPos.headerElements = this.tclm.getHeaderElements();
                }
                if (!this.getTableLM().getTable().omitFooterAtBreak()) {
                    effPenaltyLen += this.tclm.getFooterNetHeight();
                    penaltyPos.footerElements = this.tclm.getFooterElements();
                }
            }
            if (this.lastMaxPenaltyLength != 0) {
                penaltyPos.nestedPenaltyLength = this.lastMaxPenaltyLength;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Additional penalty length from table-cell break: " + this.lastMaxPenaltyLength));
                }
            }
            effPenaltyLen += this.lastMaxPenaltyLength;
            int p = 0;
            boolean allCellsHaveContributed = true;
            signalKeepWithNext = false;
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.start[i] == 0 && this.end[i] < 0 && this.elementLists[i] != null) {
                    allCellsHaveContributed = false;
                }
                signalKeepWithNext |= this.keepWithNextSignals[i];
            }
            if (!allCellsHaveContributed) {
                p = 900;
            }
            if (signalKeepWithNext || this.getTableLM().mustKeepTogether()) {
                p = 1000;
            }
            if (this.skippedStep) {
                p = 1000;
            }
            if (forcedBreak) {
                if (this.skippedStep) {
                    log.error((Object)"This is a conflict situation. The output may be wrong. Please send your FO file to fop-dev@xmlgraphics.apache.org!");
                }
                p = -1000;
            }
            returnList.add(new BreakElement(penaltyPos, effPenaltyLen, p, breakClass, context));
            if (log.isDebugEnabled()) {
                log.debug((Object)("step=" + step + " (+" + increase + ")" + " box=" + boxLen + " penalty=" + penaltyLen + " effPenalty=" + effPenaltyLen));
            }
            laststep = step;
            if (!this.rowBacktrackForLastStep) continue;
            ++this.activeRowIndex;
        }
        if (signalKeepWithNext) {
            context.setFlags(512);
        }
        if (lastTCPos != null) {
            lastTCPos.setFlag(2, true);
        }
        return returnList;
    }

    private int getNextStep() {
        int len;
        int i;
        log.trace((Object)"Entering getNextStep");
        this.lastMaxPenaltyLength = 0;
        int[] backupWidths = new int[this.columnCount];
        System.arraycopy(this.widths, 0, backupWidths, 0, this.columnCount);
        this.goToNextRowIfCurrentFinished(backupWidths);
        boolean stepFound = false;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (this.elementLists[i2] == null) continue;
            while (this.end[i2] + 1 < this.elementLists[i2].size()) {
                int n = i2;
                this.end[n] = this.end[n] + 1;
                KnuthElement el = (KnuthElement)this.elementLists[i2].get(this.end[i2]);
                if (el.isPenalty()) {
                    this.lastMaxPenaltyLength = Math.max(this.lastMaxPenaltyLength, el.getW());
                    if (el.getP() <= -1000) {
                        log.debug((Object)"FORCED break encountered!");
                        break;
                    }
                    if (el.getP() >= 1000) continue;
                    break;
                }
                if (el.isGlue()) {
                    KnuthElement prev;
                    if (this.end[i2] > 0 && (prev = (KnuthElement)this.elementLists[i2].get(this.end[i2] - 1)).isBox()) break;
                    int n2 = i2;
                    this.widths[n2] = this.widths[n2] + el.getW();
                    continue;
                }
                int n3 = i2;
                this.widths[n3] = this.widths[n3] + el.getW();
            }
            if (this.end[i2] < this.start[i2]) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("column " + (i2 + 1) + ": (end=" + this.end[i2] + ") < (start=" + this.start[i2] + ") => resetting width to backupWidth"));
                }
                this.widths[i2] = backupWidths[i2];
            } else {
                stepFound = true;
            }
            this.borderAfter[i2] = this.end[i2] + 1 >= this.elementLists[i2].size() ? (this.isSeparateBorderModel() ? this.getActivePrimaryGridUnit(i2).getBorders().getBorderAfterWidth(false) : this.getActivePrimaryGridUnit(i2).getHalfMaxAfterBorderWidth()) : (this.isSeparateBorderModel() ? this.getActivePrimaryGridUnit(i2).getBorders().getBorderAfterWidth(false) : this.getActivePrimaryGridUnit(i2).getHalfMaxAfterBorderWidth());
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("column " + (i2 + 1) + ": borders before=" + this.borderBefore[i2] + " after=" + this.borderAfter[i2]));
            log.trace((Object)("column " + (i2 + 1) + ": padding before=" + this.paddingBefore[i2] + " after=" + this.paddingAfter[i2]));
        }
        if (!stepFound) {
            return -1;
        }
        int minStep = Integer.MAX_VALUE;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.columnCount; ++i) {
            this.baseWidth[i] = 0;
            for (int prevRow = 0; prevRow < this.startRow[i]; ++prevRow) {
                int n = i;
                this.baseWidth[n] = this.baseWidth[n] + this.rowGroup[prevRow].getHeight().opt;
            }
            int n = i;
            this.baseWidth[n] = this.baseWidth[n] + 2 * this.getTableLM().getHalfBorderSeparationBPD();
            int n4 = i;
            this.baseWidth[n4] = this.baseWidth[n4] + (this.borderBefore[i] + this.borderAfter[i]);
            int n5 = i;
            this.baseWidth[n5] = this.baseWidth[n5] + (this.paddingBefore[i] + this.paddingAfter[i]);
            if (this.end[i] < this.start[i]) continue;
            len = this.baseWidth[i] + this.widths[i];
            sb.append(len + " ");
            minStep = Math.min(len, minStep);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("candidate steps: " + sb));
        }
        this.rowBacktrackForLastStep = false;
        this.skippedStep = false;
        for (i = 0; i < this.columnCount; ++i) {
            len = this.baseWidth[i] + this.widths[i];
            if (len <= minStep) continue;
            this.widths[i] = backupWidths[i];
            this.end[i] = this.start[i] - 1;
            if (this.baseWidth[i] + this.widths[i] <= minStep) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("column " + (i + 1) + ": minStep vs. border/padding increase conflict: basewidth + width = " + this.baseWidth[i] + " + " + this.widths[i] + " = " + (this.baseWidth[i] + this.widths[i])));
            }
            if (this.activeRowIndex == 0) {
                log.debug((Object)"  First row. Skip this step.");
                this.skippedStep = true;
                continue;
            }
            log.debug((Object)"  row-span situation: backtracking to last row");
            this.rowBacktrackForLastStep = true;
        }
        if (log.isDebugEnabled()) {
            sb = new StringBuffer("[col nb: start-end(width)] ");
            for (i = 0; i < this.columnCount; ++i) {
                if (this.end[i] >= this.start[i]) {
                    sb.append(i + ": " + this.start[i] + "-" + this.end[i] + "(" + this.widths[i] + "), ");
                    continue;
                }
                sb.append(i + ": skip, ");
            }
            log.debug((Object)sb.toString());
        }
        return minStep;
    }

    private void goToNextRowIfCurrentFinished(int[] backupWidths) {
        boolean currentGridRowFinished = true;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.elementLists[i] == null) continue;
            if (this.end[i] < this.elementLists[i].size()) {
                this.start[i] = this.end[i] + 1;
                if (this.end[i] + 1 >= this.elementLists[i].size() || !this.getActiveGridUnit(i).isLastGridUnitRowSpan()) continue;
                currentGridRowFinished = false;
                continue;
            }
            throw new IllegalStateException("end[i] overflows elementList[i].size()");
        }
        if (currentGridRowFinished && this.activeRowIndex < this.rowGroup.length - 1) {
            TableRow rowFO = this.getActiveRow().getTableRow();
            if (rowFO != null && rowFO.getBreakAfter() != 9) {
                log.warn((Object)FONode.decorateWithContextInfo("break-after ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.1)", rowFO));
            }
            ++this.activeRowIndex;
            if (log.isDebugEnabled()) {
                log.debug((Object)("===> new row: " + this.activeRowIndex));
            }
            this.initializeElementLists();
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.end[i] >= 0) continue;
                backupWidths[i] = 0;
            }
            rowFO = this.getActiveRow().getTableRow();
            if (rowFO != null && rowFO.getBreakBefore() != 9) {
                log.warn((Object)FONode.decorateWithContextInfo("break-before ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.2)", rowFO));
            }
        }
    }

    private boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    private TableLayoutManager getTableLM() {
        return this.tclm.getTableLM();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KnuthBoxCellWithBPD
    extends KnuthBox {
        public KnuthBoxCellWithBPD(int w) {
            super(w, null, true);
        }
    }
}

