/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFObject;

public class PDFLimits
extends PDFObject {
    private ArrayList destinationList;

    public PDFLimits(ArrayList destinationList) {
        this.destinationList = destinationList;
    }

    public String toPDFString() {
        String[] idRefs = new String[this.destinationList.size()];
        String kidsString = "";
        for (int i = 0; i < this.destinationList.size(); ++i) {
            PDFDestination dest = (PDFDestination)this.destinationList.get(i);
            idRefs[i] = dest.getIDRef();
            kidsString = kidsString + dest.referencePDF();
            if (i == this.destinationList.size() - 1) continue;
            kidsString = kidsString + " ";
        }
        String s = this.getObjectID() + "<<\n" + "/Limits [(" + idRefs[0] + ") (" + idRefs[this.destinationList.size() - 1] + ")]\n" + "/Kids [" + kidsString + "]" + "\n>>\nendobj\n";
        return s;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj instanceof PDFLimits;
    }
}

