/*
 * Decompiled with CFR 0.152.
 */
package electric.application;

import electric.application.Application;
import electric.application.simple.SimpleApplication;
import electric.application.web.WebApplication;
import electric.glue.IGLUEConfigConstants;
import electric.glue.IGLUEContextConstants;
import electric.servlet.webinf.IWebInfConstants;
import electric.util.Context;
import electric.util.fileloader.archive.ArchiveLoader;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import java.util.Hashtable;
import javax.servlet.ServletContext;

public class Applications
implements ILoggingConstants,
IGLUEContextConstants,
IGLUEConfigConstants,
IWebInfConstants {
    private static Application defaultApplication = null;
    private static Hashtable contextToApplication = new Hashtable();
    private static boolean isHosted = false;
    private static Hashtable nameToApplication = new Hashtable();

    public static Application getDefaultApplication() {
        if (defaultApplication == null) {
            Applications.initDefaultApplication();
        }
        return defaultApplication;
    }

    private static void initDefaultApplication() {
        block2: {
            try {
                defaultApplication = new SimpleApplication(Product.getConfig("glue", null));
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.CONFIG_EVENT)) break block2;
                Log.log(ILoggingConstants.CONFIG_EVENT, "Could not initialize default application.", exception);
            }
        }
    }

    public static boolean isHosted() {
        return isHosted;
    }

    public static void setHosted(boolean isHosted) {
        Applications.isHosted = isHosted;
    }

    public static Application getApplication(String name) {
        return (Application)nameToApplication.get(name);
    }

    public static Application getCurrentApplication() {
        Context threadContext = Context.thread();
        Application app = (Application)threadContext.getProperty("application");
        if (app != null) {
            return app;
        }
        return Applications.getDefaultApplication();
    }

    public static String addApplication(String name, Application application) {
        String newName = name;
        int i = 0;
        while (nameToApplication.contains(newName)) {
            newName = name + i;
            ++i;
        }
        nameToApplication.put(newName, application);
        return newName;
    }

    public static Application getApplication(ServletContext context) {
        Application application = (Application)contextToApplication.get(context);
        if (application != null) {
            return application;
        }
        return Applications.createApplication(context);
    }

    private static Application createApplication(ServletContext context) {
        WebApplication application;
        String appHome = context.getRealPath("WEB-INF");
        if (appHome != null) {
            String appPath = appHome.substring(0, appHome.toUpperCase().lastIndexOf("WEB-INF"));
            application = new WebApplication(appPath);
        } else {
            String appName = context.getServletContextName();
            if (appName == null) {
                appName = "GLUE WEBAPP";
            }
            Context.application().setProperty("glue.apphome", "");
            application = new WebApplication(appName, new ArchiveLoader(context));
        }
        contextToApplication.put(context, application);
        return application;
    }

    public static void registerApplication(String contextPath, Application application) {
        nameToApplication.put(contextPath, application);
    }
}

