/*
 * Decompiled with CFR 0.152.
 */
package electric.application.tools;

import electric.application.DeploymentException;
import electric.application.IApplication;
import electric.application.tools.Utils;
import electric.util.tool.ToolUtil;

public class Undeploy {
    private static String appName;
    private static String servicesURL;
    private static String servicePath;
    private static String jarFile;

    public static void main(String[] args) {
        if (args.length == 0) {
            Undeploy.printUsage();
            return;
        }
        try {
            Undeploy.processArgs(args);
            Undeploy.undeploy();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Undeploy.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: undeploy [-Dname=value]* [-h] {appname | url} { service-path | file.jar | file.zip }");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  -h           = print help and exit");
        System.out.println("  appname      = local application name");
        System.out.println("  url          = undeploy jar file");
        System.out.println("  file.zip     = undeploy zip file");
        System.out.println("  file.jar     = remote application service root");
        System.out.println("  service-path = path of service to undeploy");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("undeploy app1 sample");
        System.out.println("  delete app1\\WEB-INF\\services\\sample.xml");
        System.out.println();
        System.out.println("undeploy http://host:9000/app1/services foo/bar");
        System.out.println("  delete WEB-INF\\services\\foo\\bar.xml in remote application");
    }

    private static void processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                if (appName == null) {
                    appName = arg;
                } else {
                    String extension;
                    String string = extension = arg.lastIndexOf(".") > -1 ? arg.substring(arg.lastIndexOf(".")) : null;
                    if (extension != null && (extension.equalsIgnoreCase(".jar") || extension.equalsIgnoreCase(".zip"))) {
                        jarFile = arg;
                    } else {
                        servicePath = arg;
                    }
                }
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'h': {
                        Undeploy.printUsage();
                        System.exit(-1);
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        servicesURL = Utils.getServicesURL(appName);
    }

    private static void undeploy() throws DeploymentException {
        IApplication application = Utils.bindToApplication(servicesURL);
        if (servicePath != null) {
            Undeploy.undeployService(application, servicePath);
        } else if (jarFile != null) {
            Undeploy.undeployJar(application, jarFile);
        } else {
            throw new IllegalArgumentException("unsupported combination of arguments");
        }
    }

    private static void undeployService(IApplication application, String servicePath) throws DeploymentException {
        if (!application.removeService(servicePath)) {
            throw new DeploymentException("unable to delete service descriptor file. check server log for errors");
        }
    }

    private static void undeployJar(IApplication application, String jarFile) throws DeploymentException {
        if (!application.removeJar(jarFile)) {
            throw new DeploymentException("unable to remove the jar file from the application. the file might be locked by a running process");
        }
        System.out.println("jar file has been removed from the application");
    }
}

