/*
 * Decompiled with CFR 0.152.
 */
package electric.application.tools;

import electric.application.DeploymentException;
import electric.application.IApplication;
import electric.application.web.WebApplication;
import electric.glue.IGLUEConfigConstants;
import electric.glue.std.config.IConfigConstants;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.file.DirectoryFilter;
import electric.util.file.FileUtil;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.io.File;

public class Utils
implements IGLUEConfigConstants,
IConfigConstants {
    static /* synthetic */ Class class$electric$application$IApplication;

    public static IApplication bindToApplication(String servicesURL) throws DeploymentException {
        try {
            String url = Strings.splice(servicesURL, "system/application.wsdl");
            return (IApplication)Registry.bind(url, class$electric$application$IApplication == null ? (class$electric$application$IApplication = Utils.class$("electric.application.IApplication")) : class$electric$application$IApplication);
        }
        catch (Exception exception) {
            throw new DeploymentException("unable to bind to the deployment service at " + servicesURL + ": " + exception);
        }
        catch (NoClassDefFoundError error) {
            throw new DeploymentException("unable to bind. make sure glue platform jar files are in the classpath");
        }
    }

    public static String getServicesURL(String path) {
        if (path.toLowerCase().startsWith("http://") || path.toLowerCase().startsWith("https://")) {
            return path;
        }
        path = Utils.setAppHomeFromAppName(path);
        return Utils.getLocalApplicationServerURL(path);
    }

    public static String setAppHomeFromAppName(String appName) {
        File appPath = new File(appName);
        if (appPath.exists()) {
            if (!appPath.isDirectory()) {
                throw new IllegalArgumentException("application path must point to a directory");
            }
            String appHome = appPath.getParent();
            appName = appPath.getName();
            appHome = appHome == null ? File.separator : appHome;
            System.getProperties().setProperty("glue.apphome", appHome);
            Context.application().setProperty("glue.apphome", appHome);
        }
        return appName;
    }

    public static String getLocalApplicationServerURL(String appName) {
        File appPath = new File(appName);
        if (!appPath.exists()) {
            appPath = new File(WebApplication.getAppHome(), appName);
        }
        if (!appPath.exists()) {
            System.out.println("unable to find application directory at " + appPath.getAbsolutePath());
            return null;
        }
        File configFile = new File(appPath, "WEB-INF" + File.separator + "glue-config.xml");
        if (!configFile.exists()) {
            System.out.println("unable to find glue-config.xml at " + configFile.getAbsolutePath());
            return "http://localhost:8004/" + appName + "/services";
        }
        Document config = null;
        try {
            config = new Document(configFile);
        }
        catch (ParseException exception) {
            System.out.println("unable to parse application configuration file. cannot determine local server URL");
            return null;
        }
        Element webServer = config.getRoot().getElement("webServer");
        if (webServer == null) {
            System.out.println("cannot determine local server URL. webServer element is missing in the configuration file");
            return null;
        }
        String webServerURL = webServer.getTrimTextString("url");
        webServerURL = Strings.replace(webServerURL, "$APPNAME", appName);
        return Strings.splice(webServerURL, "/services");
    }

    public static File[] getAppDirs(String appHome) throws IllegalArgumentException {
        return Utils.getAppDirs(new File(appHome));
    }

    public static File[] getAppDirs(File appHomeDir) {
        if (appHomeDir.exists()) {
            return FileUtil.listFiles(appHomeDir, false, new DirectoryFilter());
        }
        throw new IllegalArgumentException("unable to find application home at " + appHomeDir.getAbsolutePath());
    }

    public static File getAppDir(String appPath) throws IllegalArgumentException {
        File appDir = new File(appPath);
        if (appDir.exists()) {
            return appDir;
        }
        appDir = new File(WebApplication.getAppHome(), appPath);
        if (appDir.exists()) {
            return appDir;
        }
        throw new IllegalArgumentException("unable to find application at " + appDir.getPath());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

