/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.classes;

import electric.application.web.classes.IClassConstants;
import electric.util.array.ArrayUtil;
import electric.util.classpath.IClassPathEventListener;
import electric.util.directory.filters.ExtensionFilter;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import java.io.File;

public final class ClassMonitor
implements IFileEventListener,
IClassConstants {
    private IClassPathEventListener[] listeners = new IClassPathEventListener[0];
    private MonitoredRoot[] roots = new MonitoredRoot[0];

    public ClassMonitor() {
    }

    public ClassMonitor(String webInfRoot, IClassPathEventListener[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            this.addListener(listeners[i]);
            ++i;
        }
        String classesPath = webInfRoot + "classes";
        this.monitorPath(classesPath, IClassConstants.CLASS_EXTENSIONS);
        String libPath = webInfRoot + "lib";
        this.monitorPath(libPath, IClassConstants.LIB_EXTENSIONS);
    }

    public void monitorPath(String path, String[] extensions) {
        ExtensionFilter filter = new ExtensionFilter(extensions);
        MonitoredRoot root = new MonitoredRoot(new File(path), true, false, filter, true);
        this.roots = (MonitoredRoot[])ArrayUtil.addElement(this.roots, root);
        root.addEventListener(this);
    }

    public void start() {
        int i = 0;
        while (i < this.roots.length) {
            this.roots[i].start();
            ++i;
        }
    }

    public void stop() {
        int i = 0;
        while (i < this.roots.length) {
            this.roots[i].stop();
            ++i;
        }
    }

    public void cycle() {
        int i = 0;
        while (i < this.roots.length) {
            this.roots[i].cycle();
            ++i;
        }
    }

    public void addListener(IClassPathEventListener listener) {
        this.listeners = (IClassPathEventListener[])ArrayUtil.addElement(this.listeners, listener);
    }

    public void filesAdded(File[] files) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].classesAdded(files);
            ++i;
        }
    }

    public void filesRemoved(File[] files) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].classesRemoved(files);
            ++i;
        }
    }

    public void filesModified(File[] files) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].classesModified(files);
            ++i;
        }
    }
}

