/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.config;

import electric.application.web.WebAppMonitor;
import electric.glue.IGLUEConfigConstants;
import electric.glue.IGLUELoggingConstants;
import electric.util.directory.filters.NameFilter;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.File;

public final class ConfigMonitor
implements IFileEventListener,
IGLUELoggingConstants,
IGLUEConfigConstants {
    private WebAppMonitor webAppMonitor;
    private MonitoredRoot root;
    private String configPath;

    public ConfigMonitor(WebAppMonitor webAppMonitor, String configPath) {
        this.webAppMonitor = webAppMonitor;
        this.configPath = configPath;
        NameFilter filter = new NameFilter("glue-config.xml");
        this.root = new MonitoredRoot(new File(configPath), false, false, filter, true);
        this.root.addEventListener(this);
    }

    public void start() {
        this.root.start();
    }

    public void stop() {
        this.root.stop();
    }

    public void filesAdded(File[] files) {
    }

    public void filesRemoved(File[] files) {
    }

    public void filesModified(File[] files) {
        block3: {
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)("configuration file at " + this.configPath + "glue-config.xml" + " has changed. Restarting application"));
            }
            try {
                this.webAppMonitor.restart();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, "error restarting application", exception);
            }
        }
    }
}

