/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.maps;

import electric.application.web.WebApplication;
import electric.application.web.maps.MapMonitor;
import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.util.fileloader.IFileEntry;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.io.Mappings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class MapManager
implements IGLUELoggingConstants,
IConfigConstants {
    private WebApplication application;
    private MapMonitor mapMonitor;

    public MapManager(WebApplication application) {
        this.application = application;
        if (application.isHotDeployable()) {
            this.mapMonitor = new MapMonitor(this, application.getMapsRoot());
        }
    }

    public void start() {
        this.addMapsFromWebInf();
        this.addMapsFromConfig();
        if (this.mapMonitor != null) {
            this.mapMonitor.start();
        }
    }

    public void stop() {
        if (this.mapMonitor != null) {
            this.mapMonitor.stop();
        }
    }

    private void addMapsFromWebInf() {
        block3: {
            try {
                String mapFileRoot = this.application.getMapsRoot();
                IFileEntry[] mapFiles = this.application.getFileLoader().getEntries(mapFileRoot);
                int i = 0;
                while (i < mapFiles.length) {
                    this.addMapping(mapFiles[i]);
                    ++i;
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not get map file list", exception);
            }
        }
    }

    private void addMapsFromConfig() {
        String mapFileRoot = this.application.getMapsRoot();
        Element config = this.application.getConfig();
        if (!config.hasElement("mapFiles")) {
            return;
        }
        Elements mapFiles = config.getElement("mapFiles").getElements("path");
        while (mapFiles.hasMoreElements()) {
            String path = mapFileRoot + mapFiles.next().getString();
            try {
                this.addMapping(this.application.getFileLoader().getEntry(path));
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not load map file" + path, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addMapping(IFileEntry file) throws IOException {
        block11: {
            if (!file.getName().endsWith(".map")) {
                return;
            }
            String path = file.getAbsolutePath();
            if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)(this.getAppName() + ": read mappings from " + path));
            }
            InputStream input = file.openStream();
            Mappings.readMapping(path, new Document(input));
            Object var6_4 = null;
            try {
                input.close();
            }
            catch (IOException exception2) {}
            break block11;
            {
                catch (Exception exception) {
                    if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                        Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not add map file " + path, exception);
                    }
                    Object var6_5 = null;
                    try {
                        input.close();
                    }
                    catch (IOException exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    input.close();
                }
                catch (IOException exception2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void addMapping(File file) {
        block2: {
            String path = file.getAbsolutePath();
            try {
                Mappings.readMapping(path, new Document(file));
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not add map file " + path, exception);
            }
        }
    }

    private String getAppName() {
        return this.application.getAppName();
    }
}

