/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.servlets;

import electric.application.DeploymentException;
import electric.application.web.WebApplication;
import electric.application.web.managed.ManagedObject;
import electric.application.web.servlets.ServletManager;
import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.servlet.webinf.IWebInfConstants;
import electric.servlet.webinf.WebInf;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.resourceloader.ResourceLoaders;
import electric.util.string.Strings;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletException;

public final class ManagedServlets
extends ManagedObject
implements IConfigConstants,
IWebInfConstants {
    private static final String ELECTRIC_HTTP_URL = "electric.http.url";
    private static final String CLASS_PATH_SOURCE = "electric.classpathsource";
    private static final String DEFAULT_WEB_XML = "default-web.xml";
    private XURL xurl;
    private HTTPContext httpContext;
    static /* synthetic */ Class class$electric$server$http$ServletServer;

    public ManagedServlets(ServletManager servletManager, Element element) throws Exception {
        super(servletManager);
        WebApplication application = servletManager.getApplication();
        String appURL = application.getAppURL();
        String appName = application.getAppName();
        appURL = this.getAppURL(appURL, appName, element);
        this.xurl = new XURL(appURL);
        WebInf webInf = this.getWebInf();
        String docBase = application.getAppPath();
        this.httpContext = webInf.getHTTPContext(docBase);
        Element defaultWebApp = application.getConfig().getElement("base-web-app");
        WebInf defaultWebInf = new WebInf(defaultWebApp);
        HTTPContext defaultHTTPContext = defaultWebInf.getHTTPContext(null);
        Hashtable mappings = defaultHTTPContext.getServletMappings();
        Enumeration enumeration = mappings.keys();
        while (enumeration.hasMoreElements()) {
            String urlPattern = (String)enumeration.nextElement();
            if (this.httpContext.getServletMapping(urlPattern) != null) continue;
            this.httpContext.addConfig(urlPattern, defaultHTTPContext.getServletMapping(urlPattern));
        }
        WebServer webServer = WebServers.startWebServer(this.xurl);
        int port = webServer.getXURL().getPort();
        this.xurl = new XURL(this.xurl.getProtocol(), this.xurl.getHost(), port, this.xurl.getFile(), this.xurl.getReference());
        this.setAppPath(this.xurl.toString(), this.httpContext);
        String path = HTTPUtil.getContextPath(this.xurl);
        webServer.addContext(path, this.httpContext, false);
        if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("web server started on " + webServer.getXURL()));
        }
    }

    private String getAppURL(String appURL, String appName, Element element) {
        if (appURL == null) {
            String url = element.getString("url");
            return Strings.replace(url, "$APPNAME", appName);
        }
        if (Character.isDigit(appURL.charAt(0))) {
            return "http://localhost:" + appURL + "/" + appName;
        }
        return appURL;
    }

    private void setAppPath(String appURL, HTTPContext httpContext) {
        Vector configs = httpContext.getConfigs();
        int i = 0;
        while (i < configs.size()) {
            Config config = (Config)configs.elementAt(i);
            if (config.getClassName().equals((class$electric$server$http$ServletServer == null ? ManagedServlets.class$("electric.server.http.ServletServer") : class$electric$server$http$ServletServer).getName())) {
                String urlPattern = httpContext.getServletMappings(config.getServletName())[0];
                String path = Strings.splice(appURL, urlPattern);
                if (path.endsWith("/*")) {
                    path = path.substring(0, path.length() - 2);
                }
                config.addInitParameter(ELECTRIC_HTTP_URL, path);
                return;
            }
            ++i;
        }
    }

    private WebInf getWebInf() throws IOException, ParseException {
        try {
            return this.getWebInf(this.getApplication().getAppPath() + File.separator + "WEB-INF" + File.separator + "web.xml");
        }
        catch (IOException exception) {
            return this.getWebInf(DEFAULT_WEB_XML);
        }
    }

    private WebInf getWebInf(String path) throws IOException, ParseException {
        byte[] bytes = ResourceLoaders.loadResource(path);
        Document document = new Document(bytes);
        return new WebInf(document.getRoot());
    }

    public HTTPContext getHTTPContext() {
        return this.httpContext;
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        this.httpContext.setClassLoader(classLoader);
        this.httpContext.setAttribute(CLASS_PATH_SOURCE, this.getApplication().getClassPathSource());
    }

    public void begin() throws Throwable {
        try {
            this.httpContext.startup();
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": started web application " + this.xurl));
            }
        }
        catch (Throwable exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not start web application " + this.xurl, exception);
            }
            throw exception;
        }
    }

    public void end() throws Throwable {
        try {
            this.httpContext.shutdown();
            WebServer webServer = this.httpContext.getWebServer();
            webServer.removeContext(HTTPUtil.getContextPath(this.xurl));
            if (webServer.getAllContexts().length == 0) {
                webServer.shutdown();
            }
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": stopped web application " + this.xurl));
            }
        }
        catch (Throwable exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not stop web application " + this.xurl, exception);
            }
            throw exception;
        }
    }

    public Config getConfigWithServletName(String name) {
        return this.httpContext.getConfigWithServletName(name);
    }

    public void enableServlet(String name) throws DeploymentException {
        Config servletConfig = this.getConfigWithServletName(name);
        if (servletConfig == null) {
            String message = this.getAppName() + ": could not enable missing servlet " + name;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)message);
            }
            throw new DeploymentException(message);
        }
        try {
            servletConfig.startup();
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": enabled servlet " + name));
            }
        }
        catch (ServletException exception) {
            String message = this.getAppName() + ": could not enable servlet " + name;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, message, exception);
            }
            throw new DeploymentException(message);
        }
    }

    public void disableServlet(String name) throws DeploymentException {
        Config servletConfig = this.getConfigWithServletName(name);
        if (servletConfig == null) {
            String message = this.getAppName() + ": could not disable missing servlet " + name;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)message);
            }
            throw new DeploymentException(message);
        }
        servletConfig.shutdown();
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": disabled servlet " + name));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

