/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.servlets;

import electric.application.web.servlets.ServletManager;
import electric.glue.IGLUELoggingConstants;
import electric.util.directory.filters.NameFilter;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import electric.util.log.Log;
import java.io.File;

public final class WebMonitor
implements IFileEventListener,
IGLUELoggingConstants {
    private ServletManager servletManager;
    private MonitoredRoot root;

    public WebMonitor(ServletManager servletManager, String path) {
        this.servletManager = servletManager;
        NameFilter filter = new NameFilter("web.xml");
        this.root = new MonitoredRoot(new File(path), false, false, filter, true);
        this.root.addEventListener(this);
    }

    public void start() {
        this.root.start();
    }

    public void stop() {
        this.root.stop();
    }

    public void filesAdded(File[] files) {
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": web.xml added"));
        }
        this.servletManager.startWebApp();
    }

    public void filesRemoved(File[] files) {
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": web.xml removed"));
        }
        this.servletManager.stopWebApp();
    }

    public void filesModified(File[] files) {
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": web.xml modified"));
        }
        this.servletManager.restartWebApp();
    }

    private String getAppName() {
        return this.servletManager.getAppName();
    }
}

