/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.httpoversoap;

import electric.cluster.httpoversoap.HTTPRequestInfo;
import electric.net.channel.IChannel;
import electric.util.XURL;
import electric.util.http.IHTTPConstants;
import electric.util.mime.MIMEHeaders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;

public class StaticChannel
implements IChannel {
    private InputStream inputStream;
    private OutputStream outputStream;

    public StaticChannel(HTTPRequestInfo requestInfo) {
        StringBuffer command = new StringBuffer();
        command.append(requestInfo.getRequestType());
        command.append(" ");
        command.append(requestInfo.getRequestURI());
        command.append(" ");
        command.append("HTTP/1.1\r\n");
        MIMEHeaders headers = requestInfo.getMIMEHeaders();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            headers.writeHeaders(outputStream);
            outputStream.write(IHTTPConstants.EOL);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        ByteArrayInputStream commandStream = new ByteArrayInputStream(command.toString().getBytes());
        ByteArrayInputStream headerStream = new ByteArrayInputStream(outputStream.toByteArray());
        SequenceInputStream commandHeaderStream = new SequenceInputStream(commandStream, headerStream);
        ByteArrayInputStream bodyStream = new ByteArrayInputStream(requestInfo.getBodyBytes());
        this.inputStream = new SequenceInputStream(commandHeaderStream, bodyStream);
        this.outputStream = new ByteArrayOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void close() throws IOException {
    }

    public XURL getLocalXURL() {
        return null;
    }

    public XURL getRemoteXURL() {
        return null;
    }

    public long getBytesRead() {
        return 0L;
    }

    public long getBytesWritten() {
        return 0L;
    }

    public int getState() {
        return 0;
    }

    public void setState(int state) {
    }

    public void clearOutputStream() {
        ((ByteArrayOutputStream)this.outputStream).reset();
    }
}

