/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.lifecycle;

import electric.application.tools.Utils;
import electric.application.web.WebAppMonitor;
import electric.cluster.IClusterConstants;
import electric.cluster.lifecycle.ILivenessService;
import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.constructor.Constructor;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.thread.Task;
import electric.util.thread.Tasks;
import java.io.File;

public class ApplicationLauncher
implements Runnable,
IGLUELoggingConstants,
IClusterConstants {
    private String livenessUrl;
    private WebAppMonitor webAppMonitor;
    private ILivenessService service;
    static /* synthetic */ Class class$electric$cluster$ClusteredApplication;
    static /* synthetic */ Class class$electric$cluster$lifecycle$ILivenessService;

    public ApplicationLauncher(String livenessUrl) {
        this.livenessUrl = livenessUrl;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            throw new IllegalStateException("ApplicationLauncher is for internal use only");
        }
        String applicationRoot = args[0];
        String url = args[1];
        String parentUrl = args[2];
        boolean master = args[3].equalsIgnoreCase("true");
        String wssUrl = args[4];
        System.getProperties().setProperty("glue.childvm", "true");
        System.getProperties().setProperty("wssUrl", wssUrl);
        ApplicationLauncher launcher = new ApplicationLauncher(parentUrl + "system/liveness.wsdl");
        launcher.start(applicationRoot, url, master);
        Tasks.getShared().add(new Task(launcher, "parentMonitor", 0L, 0L, 5000L, true));
    }

    public void start(String applicationRoot, String url, boolean master) throws Exception {
        File applicationFile = Utils.getAppDir(applicationRoot);
        String appPath = applicationFile.getCanonicalPath();
        if (!appPath.endsWith(File.separator)) {
            appPath = appPath + File.separator;
        }
        String appUrl = url + applicationFile.getName();
        String[] args = new String[]{appPath, appUrl, String.valueOf(master)};
        String className = (class$electric$cluster$ClusteredApplication == null ? (class$electric$cluster$ClusteredApplication = ApplicationLauncher.class$("electric.cluster.ClusteredApplication")) : class$electric$cluster$ClusteredApplication).getName();
        Constructor constructor = new Constructor(className, args);
        this.webAppMonitor = new WebAppMonitor(applicationFile, appUrl, constructor);
        this.webAppMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (this.service == null) {
                this.service = (ILivenessService)Registry.bind(this.livenessUrl, class$electric$cluster$lifecycle$ILivenessService == null ? (class$electric$cluster$lifecycle$ILivenessService = ApplicationLauncher.class$("electric.cluster.lifecycle.ILivenessService")) : class$electric$cluster$lifecycle$ILivenessService);
            }
            this.service.livenessPing();
        }
        catch (RegistryException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
        }
        catch (Exception exception) {
            try {
                try {
                    this.webAppMonitor.stop();
                }
                catch (Exception ignore) {
                    Object var5_5 = null;
                    System.exit(0);
                }
                Object var5_4 = null;
                System.exit(0);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                System.exit(0);
                throw throwable;
            }
        }
        try {
            Thread.sleep(5000L);
            return;
        }
        catch (InterruptedException ignore) {
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

