/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.server;

import electric.cluster.IClusterConstants;
import electric.cluster.lifecycle.ILifecycleCommand;
import electric.cluster.lifecycle.LifecycleCommandFactory;
import electric.cluster.lifecycle.ShutdownHook;
import electric.cluster.manager.ClusterManager;
import electric.cluster.monitor.ClusterMonitor;
import electric.cluster.server.AppServerMonitor;
import electric.cluster.server.IApplicationServer;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ServiceContext;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.file.FileUtil;
import electric.util.thread.Task;
import electric.util.thread.Tasks;
import java.io.File;
import java.util.Hashtable;

public class ApplicationServer
implements IApplicationServer,
IClusterConstants,
IGLUELoggingConstants {
    private static boolean master;
    private static String applicationsRoot;
    private static final ApplicationServer INSTANCE;
    private AppServerMonitor serverMonitor;
    private Task task;
    private String[] applications = new String[0];
    private String[] deletedApps = new String[0];
    private Hashtable nameToLifecycleCommand = new Hashtable();
    private StringBuffer applicationSignature = new StringBuffer("");
    static /* synthetic */ Class class$electric$cluster$manager$IClusterManager;

    private ApplicationServer() {
    }

    public static ApplicationServer getInstance() {
        return INSTANCE;
    }

    public void start() throws Exception {
        File appHomeDir = new File(applicationsRoot);
        if (!master) {
            this.initSlave(appHomeDir);
        }
        this.serverMonitor = new AppServerMonitor(appHomeDir, this);
        this.serverMonitor.start();
        this.initializeShutdown();
        if (master) {
            this.startMaster();
        } else {
            this.startSlave();
        }
    }

    public void addApplication(File applicationRoot) throws Exception {
        String name = applicationRoot.getName();
        String applicationPath = applicationRoot.getCanonicalPath();
        this.startApplication(applicationPath);
        this.updateApplicationSignature(name);
        this.applications = (String[])ArrayUtil.addElement(this.applications, name);
    }

    public void removeApplication(File applicationRoot, boolean markAsDeleted) throws Exception {
        String applicationPath = applicationRoot.getCanonicalPath();
        ILifecycleCommand command = (ILifecycleCommand)this.nameToLifecycleCommand.remove(applicationPath);
        if (command != null) {
            command.stopApplication();
        }
        this.removeApplicationFromSignature(applicationRoot.getName());
        this.applications = (String[])ArrayUtil.removeElement(this.applications, applicationRoot.getName());
        if (markAsDeleted) {
            this.deletedApps = (String[])ArrayUtil.addElement(this.deletedApps, applicationRoot.getName());
        }
    }

    public void deleteApplication(File applicationRoot) {
        if (applicationRoot.exists()) {
            FileUtil.delete(applicationRoot);
        }
    }

    public boolean applicationExists(String applicationName) {
        return this.nameToLifecycleCommand.get(applicationName) != null;
    }

    public String[] listApplications() {
        return this.applications;
    }

    public String[] getDeletedApplications() {
        return this.deletedApps;
    }

    public String getApplicationSignature() {
        return this.applicationSignature.toString();
    }

    private void startApplication(String applicationRoot) throws Exception {
        ILifecycleCommand command = LifecycleCommandFactory.newLifecycleCommand(applicationRoot);
        command.startApplication();
        this.nameToLifecycleCommand.put(applicationRoot, command);
    }

    private void updateApplicationSignature(String applicationName) {
        this.applicationSignature.append("|" + applicationName);
    }

    private void removeApplicationFromSignature(String applicationName) {
        String remove = "|" + applicationName;
        int begin = this.applicationSignature.toString().lastIndexOf(remove);
        int end = begin + remove.length();
        this.applicationSignature = this.applicationSignature.replace(begin, end, "");
    }

    private void initializeShutdown() {
        try {
            Runtime runtime = Runtime.getRuntime();
            ShutdownHook runnable = new ShutdownHook(this.nameToLifecycleCommand);
            Thread shutdownThread = new Thread(runnable);
            shutdownThread.setDaemon(true);
            runtime.addShutdownHook(shutdownThread);
        }
        catch (Exception exception) {}
    }

    private void startMaster() throws Exception {
        ClusterManager manager = new ClusterManager(applicationsRoot, this);
        ServiceContext context = new ServiceContext();
        context.addProperty("service.systemService", "true");
        Registry.publish("system/clusterManager", (Object)manager, class$electric$cluster$manager$IClusterManager == null ? (class$electric$cluster$manager$IClusterManager = ApplicationServer.class$("electric.cluster.manager.IClusterManager")) : class$electric$cluster$manager$IClusterManager, (Context)context);
    }

    private void initSlave(File appHome) {
        File[] files = appHome.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                FileUtil.delete(files[i], true);
            }
            files[i].delete();
            ++i;
        }
    }

    private void startSlave() throws Exception {
        long startAt = System.currentTimeMillis() + 1000L;
        ClusterMonitor clusterMonitor = new ClusterMonitor(this);
        this.task = new Task(clusterMonitor, "clusterMonitor", startAt, 0L, 5000L, true);
        Tasks.getShared().add(this.task);
    }

    public static String getApplicationsRoot() {
        return applicationsRoot;
    }

    public static void setApplicationsRoot(String root) {
        applicationsRoot = root.endsWith(File.separator) ? root : root + File.separator;
    }

    public static boolean isMaster() {
        return master;
    }

    public static void setMaster(boolean master) {
        ApplicationServer.master = master;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INSTANCE = new ApplicationServer();
    }
}

