/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.tools;

import electric.application.web.WebAppMonitor;
import electric.glue.enterprise.config.IConfigConstants;
import electric.glue.pro.config.ConsoleConfig;
import electric.util.path.Paths;
import electric.util.tool.ToolUtil;
import java.io.File;

public class Dispatcher
implements IConfigConstants {
    private static final String DISPATCHER_APP = "webapps/dispatcher";
    private static String webServerURL;

    public static void main(String[] args) {
        try {
            Dispatcher.processArgs(args);
            Dispatcher.start();
        }
        catch (Throwable throwable) {
            Dispatcher.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: dispatcher [-jaas policyfile] [-Dname=value]* [-h] {[-p port] | [-u url]}");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -jaas policyfile = turn on java2 security using the specified policy file");
        System.out.println("  -Dname=value     = set java system property");
        System.out.println("  -h               = print help and exit");
        System.out.println("  -p port          = run dispatcher on specified port");
        System.out.println("  -u url           = run dispatcher on specified url");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("dispatcher -p 8008");
        System.out.println("  starts the dispatcher on port 8008");
    }

    private static void processArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.length() == 1) {
                throw new IllegalArgumentException("a plain - is not a valid argument");
            }
            switch (arg.charAt(1)) {
                case 'D': {
                    ToolUtil.setProperty(arg);
                    break;
                }
                case 'h': {
                    Dispatcher.printUsage();
                    System.exit(-1);
                }
                case 'p': {
                    webServerURL = args[++i];
                    break;
                }
                case 'u': {
                    webServerURL = args[++i];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                }
            }
            ++i;
        }
    }

    private static void start() throws Exception {
        File sourceDir = new File(Paths.getGlueHome(), DISPATCHER_APP);
        if (!sourceDir.exists()) {
            System.out.println("cannot find dispatcher web application; you must set the glue.home system property to inform the Glue runtime of its location");
            System.out.println("  example: ");
            System.out.println("dispatcher -Dglue.home=./webmethods/glue");
            System.exit(-1);
        }
        WebAppMonitor appMonitor = new WebAppMonitor(sourceDir, webServerURL);
        appMonitor.start();
        ConsoleConfig.addConsoleModule("Glue Enterprise");
    }
}

