/*
 * Decompiled with CFR 0.152.
 */
package electric.console.handlers;

import electric.console.ConsoleServlet;
import electric.console.handlers.IConsoleHandler;
import electric.console.handlers.IHandlerConstants;
import electric.glue.pro.config.IConfigConstants;
import electric.util.string.Strings;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServiceHandler
implements IConsoleHandler,
IConfigConstants,
IHandlerConstants {
    private boolean useQueryString = false;
    private String soapServletContext;

    public ServiceHandler(ConsoleServlet handler) {
        String queryStringReqd;
        this.soapServletContext = handler.getInitParameter("soapServletContext");
        if (this.soapServletContext == null) {
            this.soapServletContext = "/";
        }
        if ((queryStringReqd = handler.getInitParameter("useQueryString")) != null) {
            this.useQueryString = new Boolean(queryStringReqd);
        }
    }

    public boolean handle(String pathInfo, Hashtable queryParams, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (pathInfo == null) {
            return false;
        }
        String newPath = Strings.splice(this.soapServletContext, pathInfo);
        RequestDispatcher dispatcher = this.getDispatcher(newPath, context, request);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    private RequestDispatcher getDispatcher(String newPath, ServletContext context, HttpServletRequest request) {
        if (!this.useQueryString) {
            return context.getRequestDispatcher(newPath);
        }
        String queryString = request.getQueryString();
        return context.getRequestDispatcher(newPath + (queryString == null ? "" : "?" + queryString));
    }
}

