/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.config;

import electric.fabric.config.IFabricConfigConstants;
import electric.glue.IGLUELoggingConstants;
import electric.servlet.HTTPContext;
import electric.servlet.authorizers.siteminder.SiteMinderAuthorizer;
import electric.util.XURL;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import electric.xml.Element;
import java.net.MalformedURLException;

public class SiteMinderConfig
implements IConfig,
IFabricConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) throws Throwable {
        Element siteminderElement = config.getElement("siteminder");
        if (siteminderElement == null) {
            return;
        }
        String webServerURL = siteminderElement.getTrimTextString("url");
        SiteMinderAuthorizer siteMinderAuthorizer = new SiteMinderAuthorizer();
        siteMinderAuthorizer.setPolicyServerAddress(siteminderElement.getTrimTextString("policyServerAddress"));
        siteMinderAuthorizer.init();
        if (webServerURL == null) {
            this.startOnAllServers(siteMinderAuthorizer);
        } else {
            this.startOnOneServer(webServerURL, siteMinderAuthorizer);
        }
    }

    public void startOnAllServers(SiteMinderAuthorizer siteMinderAuthorizer) {
        WebServer[] webServers = WebServers.getWebServers();
        int i = 0;
        while (i < webServers.length) {
            WebServer server = webServers[i];
            HTTPContext[] contexts = server.getAllContexts();
            int j = 0;
            while (j < contexts.length) {
                HTTPContext context = contexts[j];
                context.setAuthorizer(siteMinderAuthorizer);
                ++j;
            }
            ++i;
        }
    }

    public void startOnOneServer(String webServerURL, SiteMinderAuthorizer siteMinderAuthorizer) throws MalformedURLException {
        XURL xurl = new XURL(webServerURL);
        WebServer webServer = WebServers.getWebServer(xurl.getPort());
        if (webServer == null) {
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("siteminder config references unavailable webserver:" + webServerURL));
            return;
        }
        HTTPContext[] contexts = webServer.getAllContexts();
        int i = 0;
        while (i < contexts.length) {
            if (xurl.getFile().startsWith(contexts[i].getPath())) {
                contexts[i].setAuthorizer(siteMinderAuthorizer);
            }
            ++i;
        }
    }
}

