/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.console.util.ConsoleNodeWriter;
import electric.fabric.Fabric;
import electric.fabric.console.services.IDatabaseConstants;
import electric.fabric.services.ServiceManagerException;
import electric.util.XURL;
import electric.util.comparators.AscendingStringComparator;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.sorting.BubbleSort;
import electric.xdb.Data;
import electric.xdb.GroupInfo;
import electric.xdb.ServerInfo;
import electric.xdb.XDBException;
import electric.xdb.client.XDBClients;
import electric.xdb.server.Member;
import electric.xml.CData;
import electric.xml.Document;
import electric.xml.Element;
import java.io.StringWriter;
import java.util.Hashtable;

public class Database
implements ILoggingConstants,
IConsoleModule,
ITreeViewProducer,
IDatabaseConstants,
IConsoleConstants {
    private ConsoleModuleInfo moduleInfo;

    public Document getDatabasesSummary() {
        try {
            Document doc = new Document();
            doc.setRoot("DatabaseEntries").setInt("numDatabases", Fabric.getServiceManager().getGroups().length);
            return doc;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to get database count", exception);
            }
            return new Document();
        }
    }

    public Document getDatabaseNames() throws ServiceManagerException {
        String[] groupNames = Database.getDatabases();
        Document doc = new Document();
        Element root = doc.setRoot("DatabaseNames");
        Element names = root.addElement("names");
        int i = 0;
        while (i < groupNames.length) {
            names.addElement("name").setString(groupNames[i]);
            ++i;
        }
        return doc;
    }

    public static String[] getDatabases() throws ServiceManagerException {
        Object[] databaseNames = Fabric.getServiceManager().getGroups();
        BubbleSort.sort(databaseNames, new AscendingStringComparator());
        return databaseNames;
    }

    public Document getDatabaseOverview() throws ServiceManagerException {
        Document doc = new Document();
        String[] databaseNames = Database.getDatabases();
        Element root = doc.setRoot("DatabaseOverview");
        Element databases = root.addElement("databases");
        int i = 0;
        while (i < databaseNames.length) {
            try {
                String databaseName = databaseNames[i];
                GroupInfo groupInfo = XDBClients.getClient(databaseName).getGroupInfo();
                Element database = databases.addElement("database");
                database.setString("name", databaseName);
                database.setInt("preferredsize", groupInfo.getReplicationFactor());
            }
            catch (XDBException exception) {
                // empty catch block
            }
            ++i;
        }
        return doc;
    }

    public Document getDatabaseDetails(Hashtable args) {
        String databaseName = (String)args.get("databaseName");
        try {
            Document doc = new Document();
            Element root = doc.setRoot("DatabaseDetails");
            Element serviceCells = root.addElement("servicecells");
            ServerInfo detail = XDBClients.getClient(databaseName).getServerInfo();
            Element databaseElement = serviceCells.addElement("servicecell");
            databaseElement.setString("name", detail.getName());
            databaseElement.setString("url", detail.getURL());
            databaseElement.setString("host", new XURL(detail.getURL()).getHostAndPortXURL().toString());
            databaseElement.setInt("entries", detail.getDataCount());
            databaseElement.setString("leader", detail.isLeader() ? "yes" : "no");
            Member[] members = detail.getMembers();
            int i = 0;
            while (i < members.length) {
                Member member = members[i];
                if (member.isOnline()) {
                    Element memberElement = serviceCells.addElement("servicecell");
                    memberElement.setString("name", member.getName());
                    memberElement.setString("url", member.getURL());
                    memberElement.setString("host", new XURL(member.getURL()).getHostAndPortXURL().toString());
                    memberElement.setString("entries", "-");
                    memberElement.setString("leader", member.isLeader() ? "yes" : "no");
                }
                ++i;
            }
            return doc;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create database summary for " + databaseName, exception);
            }
            return new Document();
        }
    }

    public Document getDatabaseKeys(Hashtable args) throws XDBException {
        Document doc;
        block3: {
            String databaseName = (String)args.get("databaseName");
            String[] keyStrings = Database.getKeys(databaseName);
            doc = new Document();
            try {
                Element root = doc.setRoot("DatabaseKeys");
                Element keys = root.addElement("keys");
                int i = 0;
                while (i < keyStrings.length) {
                    Element keyitem = keys.addElement("keyitem");
                    keyitem.addElement("name").setString(keyStrings[i]);
                    ++i;
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create a list of keys for " + databaseName, exception);
            }
        }
        return doc;
    }

    public static String[] getKeys(String group) throws XDBException {
        Object[] keys = XDBClients.getClient(group).getAllKeys();
        BubbleSort.sort(keys, new AscendingStringComparator());
        return keys;
    }

    public Document getKeyXML(Hashtable args) {
        String group = (String)args.get("groupName");
        String key = (String)args.get("keyName");
        try {
            Data data = XDBClients.getClient(group).getDataForKey(key);
            Document doc = new Document();
            Element root = doc.setRoot("KeyXML");
            Element response = root.addElement("response");
            if (data == null) {
                response.setText(new CData("data not available"));
            } else {
                StringWriter writer = new StringWriter();
                ConsoleNodeWriter consoleWriter = new ConsoleNodeWriter(writer, 2, false, 2, "\r");
                consoleWriter.write(data.getEnvelope());
                response.setText(new CData(writer.toString()));
            }
            return doc;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create a response for " + group + ", " + key, exception);
            }
            return new Document();
        }
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("Databases");
        element.setAttribute("Name", "Databases");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Databases");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

