/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.fabric.Fabric;
import electric.fabric.console.services.DescriptionComparator;
import electric.fabric.console.services.IServicesConstants;
import electric.fabric.endpoints.EndpointInfo;
import electric.fabric.endpoints.EndpointManagerException;
import electric.fabric.endpoints.performance.PerformanceInfo;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServiceManagerException;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.sorting.BubbleSort;
import electric.util.time.TimeUtil;
import electric.xml.Children;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Node;
import java.text.DecimalFormat;
import java.util.Hashtable;

public class Services
implements IConsoleModule,
ITreeViewProducer,
IServicesConstants,
IConsoleConstants {
    private static final int CYCLE = 5000;
    private ConsoleModuleInfo moduleInfo;

    public Document getServicesSummary() {
        Document doc = new Document();
        try {
            Element root = doc.setRoot("ServicesSummary");
            int count = Fabric.getServiceManager().getServiceCount();
            root.setInt("numberservices", count);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return doc;
    }

    public Document getServicesInfo(Hashtable args) {
        String system = (String)args.get("system");
        String offline = (String)args.get("offline");
        try {
            boolean includeSystem = system.equalsIgnoreCase("true");
            boolean includeOffline = offline.equalsIgnoreCase("true");
            ServiceInfo[] serviceInfoArray = this.getServiceInfo(includeSystem, includeOffline);
            Document doc = new Document();
            Element root = doc.setRoot("ServiceList");
            Element services = root.addElement("Services");
            int i = 0;
            while (i < serviceInfoArray.length) {
                ServiceInfo serviceInfo = serviceInfoArray[i];
                Element service = services.addElement("service");
                service.setString("endpoint", serviceInfo.getEndpoint());
                service.setBoolean("online", serviceInfo.isOnline());
                service.setString("description", serviceInfo.getDescription());
                service.setString("host", new XURL(serviceInfo.getEndpoint()).getHostAndPortXURL().toString());
                XURL[] xurl = serviceInfo.getWSDL().getEndpoints();
                if (xurl.length > 0) {
                    service.setString("wsdl", xurl[0].toString());
                }
                ++i;
            }
            return doc;
        }
        catch (Exception exception) {
            return new Document();
        }
    }

    private ServiceInfo[] getServiceInfo(boolean includeSystem, boolean includeOffLine) throws ServiceManagerException {
        Object[] serviceInfo = Fabric.getServiceManager().getAllServiceInfo();
        int i = 0;
        while (i < serviceInfo.length) {
            if (!includeSystem && ((ServiceInfo)serviceInfo[i]).getMetadata("systemService") != null) {
                serviceInfo = (ServiceInfo[])ArrayUtil.removeElementAt(serviceInfo, i);
                continue;
            }
            if (!includeOffLine && !((ServiceInfo)serviceInfo[i]).isOnline()) {
                serviceInfo = (ServiceInfo[])ArrayUtil.removeElementAt(serviceInfo, i);
                continue;
            }
            ++i;
        }
        BubbleSort.sort(serviceInfo, new DescriptionComparator());
        return serviceInfo;
    }

    public Document getServiceDetails(Hashtable args) {
        String endpoint = "";
        String keyType = (String)args.get("keyType");
        if (keyType.equals("endpoint")) {
            endpoint = (String)args.get("key");
        } else {
            String wsdl = (String)args.get("key");
            try {
                ServiceInfo serviceInfo = new ServiceInfo(wsdl);
                Fabric.getServiceManager().publishUsingInfo(serviceInfo);
                endpoint = serviceInfo.getEndpoint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            ServiceInfo webServiceData = Fabric.getServiceManager().getServiceInfoForEndpoint(endpoint);
            Document doc = new Document();
            Element root = doc.setRoot("ServiceDetails");
            root.setString("endpoint", webServiceData.getEndpoint());
            root.setString("wsdl", webServiceData.getWSDLURL());
            String description = webServiceData.getDescription();
            if (description == null) {
                description = "unknown";
            }
            root.setString("description", description);
            root.setString("signature", webServiceData.getSignature());
            Element metadata = webServiceData.getMetadata();
            metadata.setName("metadata");
            root.addElement(metadata);
            return doc;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Document();
        }
    }

    public Document getActiveSessions(Hashtable args) {
        String endpoint = (String)args.get("key");
        try {
            Document doc = new Document();
            EndpointInfo[] endpointDataArray = Fabric.getEndpointManager().getEndpointInfoForURL(endpoint);
            Element root = doc.setRoot("SessionDataList");
            Element services = root.addElement("sessions");
            int i = 0;
            while (i < endpointDataArray.length) {
                EndpointInfo endpointData = endpointDataArray[i];
                Element session = services.addElement("session");
                session.setString("Host", new XURL(endpointData.getManagerURL()).getHostAndPortXURL().toString());
                ++i;
            }
            return doc;
        }
        catch (Exception exception) {
            return new Document();
        }
    }

    public Document publishService(Hashtable args) {
        return this.updateService(args);
    }

    public Document updateService(Hashtable args) {
        try {
            Document serviceDoc = new Document((String)args.get("serviceData"));
            Element service = serviceDoc.getRoot();
            String wsdl = service.getString("wsdl");
            String description = service.getString("description");
            String endpoint = service.getString("endpoint");
            Element custom = service.getElement("custom");
            Children kids = custom.getChildren();
            Node kid = kids.firstNode();
            ServiceInfo serviceInfo = new ServiceInfo(wsdl);
            if (endpoint != null) {
                serviceInfo.setEndpoint(endpoint);
            }
            serviceInfo.setDescription(description);
            while (kid != null) {
                serviceInfo.addMetadata(kid.getNodeName(), kid.getFirstChild().getNodeValue());
                kid = kid.next;
            }
            Fabric.getServiceManager().publishUsingInfo(serviceInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new Document();
    }

    public String unpublishService(Hashtable args) {
        try {
            String endpoint = (String)args.get("endpoint");
            Fabric.getServiceManager().unpublishUsingEndpoint(endpoint);
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Document getGraphData(Hashtable args) throws EndpointManagerException {
        String endpoint = (String)args.get("key");
        long stop = TimeUtil.now();
        long start = stop - 5000L;
        long duration = stop - start;
        PerformanceInfo data = Fabric.getEndpointManager().getPerformanceInfoForEndpoint(endpoint, start, stop);
        if (data == null) {
            return new Document();
        }
        try {
            Document doc = new Document();
            Element root = doc.setRoot("GaiaVitalSigns");
            float interval = (float)duration / 1000.0f;
            root.setInt("MessagesPerSecond", (int)((float)data.getRequests() / interval));
            root.setInt("ErrorsPerSecond", (int)((float)data.getExceptions() / interval));
            float kBytesPerSecond = (float)data.getTotalBytes() / interval / 1000.0f;
            if (kBytesPerSecond >= 10.0f) {
                root.setInt("BytesPerSecond", (int)kBytesPerSecond);
            } else {
                DecimalFormat decimal = new DecimalFormat("######.#");
                String string = decimal.format(kBytesPerSecond);
                root.setString("BytesPerSecond", string);
            }
            return doc;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Document();
        }
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("Web Services");
        element.setAttribute("Name", "Services");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "Web Services");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }
}

