/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.endpoints.reference;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.endpoints.Endpoint;
import electric.fabric.endpoints.EndpointManagerException;
import electric.soap.references.ISOAPReference;
import electric.soap.references.ISOAPReferenceFactory;
import electric.soap.references.SOAPReferenceFactories;
import electric.soap.references.splice.SpliceSOAPReference;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.util.log.ILoggingConstants;
import electric.wsdl.WSDL;
import java.util.Vector;

public final class MonitorSOAPReferenceFactory
implements ISOAPReferenceFactory,
IFabricConstants,
ILoggingConstants {
    public boolean newSOAPReference(Vector referenceChain, XURL endpoint, WSDL wsdl, Context proxyContext) {
        if (endpoint.getProtocol() != null) {
            return false;
        }
        String path = endpoint.getFile();
        if (!path.startsWith("?glue")) {
            return false;
        }
        if (!HTTPUtil.hasParameter(path, "intermediary")) {
            return false;
        }
        if (!HTTPUtil.hasParameter(path, "monitor")) {
            return false;
        }
        path = HTTPUtil.removeParameter(path, "monitor");
        endpoint = new XURL(endpoint.getProtocol(), endpoint.getHost(), endpoint.getPort(), path, endpoint.getReference());
        ISOAPReference nextReference = this.getSOAPReference(endpoint, wsdl, proxyContext);
        XURL xurl = nextReference.getEndpoint();
        try {
            Endpoint endpoint2 = Fabric.getEndpointManager().getEndpoint(xurl.toString());
            SpliceSOAPReference soapReference = new SpliceSOAPReference(endpoint2, proxyContext, nextReference);
            referenceChain.addElement(soapReference);
            return true;
        }
        catch (EndpointManagerException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public ISOAPReference getSOAPReference(XURL endpoint, WSDL wsdl, Context proxyContext) {
        int index = SOAPReferenceFactories.getIndex(this);
        return SOAPReferenceFactories.newSOAPReference(endpoint, wsdl, proxyContext, index);
    }
}

