/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.intermediary;

import electric.fabric.IFabricConstants;
import electric.glue.context.ProxyContext;
import electric.glue.context.ThreadContext;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.service.IService;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.references.ISOAPReference;
import electric.soap.references.SOAPReferenceFactories;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.IHTTPConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class SOAPHandler
implements ISOAPHandler,
IService,
IHTTPConstants,
IFabricConstants,
ILoggingConstants {
    private static final String SESSION_KEY = "fabric.session";
    private String mypath;
    private Context context = new Context();

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        try {
            String queryString = messageContext.getStringProperty("queryString");
            String path = "?" + queryString + "&" + "intermediary";
            ISOAPReference soapReference = this.getSOAPReference(path);
            if (Log.isLogging(IFabricConstants.INTERMEDIARY_EVENT)) {
                Log.log(IFabricConstants.INTERMEDIARY_EVENT, (Object)("url " + path + " forwarded to " + soapReference));
            }
            this.removeSomeMIMEHeaders(request);
            messageContext.setProperty("endpoint", soapReference.getEndpoint());
            return soapReference.handle(request, messageContext);
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            SOAPMessage response = new SOAPMessage();
            response.setException(exception);
            return response;
        }
    }

    private ISOAPReference getSOAPReference(String path) throws Exception {
        HttpServletRequest request = ThreadContext.getHttpRequest();
        HttpSession session = null;
        ISOAPReference reference = null;
        if (request != null) {
            session = request.getSession();
            reference = (ISOAPReference)session.getAttribute(SESSION_KEY);
            if (reference != null) {
                return reference;
            }
        } else if (Log.isLogging(IFabricConstants.INTERMEDIARY_EVENT)) {
            Log.log(IFabricConstants.INTERMEDIARY_EVENT, (Object)"Request for sessions over non-http transport.");
        }
        ProxyContext proxyContext = new ProxyContext();
        reference = SOAPReferenceFactories.newSOAPReference(new XURL(path), null, proxyContext);
        if (session != null) {
            session.setAttribute(SESSION_KEY, (Object)reference);
        }
        return reference;
    }

    private void removeSomeMIMEHeaders(SOAPMessage request) {
        request.removeMIMEHeader("Host");
        request.removeMIMEHeader("User-Agent");
        request.removeMIMEHeader("Connection");
        request.removeMIMEHeader("Content-Length");
        request.removeMIMEHeader("Content-Type");
        request.removeMIMEHeaders("Cookie");
        request.removeMIMEHeader("Expect");
    }

    public synchronized String getPath() {
        if (this.mypath != null) {
            return this.mypath;
        }
        this.mypath = Registry.getPath(this);
        return this.mypath;
    }

    public WSDL getWSDL() {
        return null;
    }

    public IReference getReference() {
        return null;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

