/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.jaxrpc;

import electric.fabric.jaxrpc.FabricService;
import electric.fabric.jaxrpc.FabricUtil;
import electric.fabric.services.ServicePath;
import electric.glue.context.ProxyContext;
import electric.net.event.NetEvent;
import electric.net.event.NetLog;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public class FabricProxy
implements InvocationHandler {
    protected FabricService fabricService;
    protected Class serviceEndpointInterface;
    protected QName portName;
    protected Service baseService;
    protected Remote baseProxy;
    protected QName serviceQName;
    protected XURL endpoint;

    public FabricProxy(FabricService fabricService, QName portName, Class serviceEndpointInterface) {
        this.fabricService = fabricService;
        this.portName = portName;
        this.serviceEndpointInterface = serviceEndpointInterface;
        this.baseService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        while (true) {
            try {
                FabricProxy fabricProxy = this;
                synchronized (fabricProxy) {
                    if (this.baseService == null) {
                        this.bind();
                    }
                }
                return method.invoke((Object)this.baseProxy, args);
            }
            catch (Throwable exception) {
                this.handleClientException(exception);
                continue;
            }
            break;
        }
    }

    public synchronized void bind() throws ServiceException {
        URL gaiaLocationSpec = FabricUtil.getLocationSpec(this.fabricService.getWSDLLocation());
        String queryString = gaiaLocationSpec.getQuery();
        boolean failover = HTTPUtil.hasParameter(queryString, "failover");
        ProxyContext proxyContext = new ProxyContext();
        ServicePath bestService = FabricUtil.getBestService(queryString = FabricUtil.addSignature(this.serviceEndpointInterface, queryString), proxyContext);
        if (bestService == null) {
            throw new JAXRPCException("failed to locate a service");
        }
        URL wsdlLocation = null;
        try {
            wsdlLocation = new URL(bestService.getServiceInfo().getWSDLURL());
        }
        catch (MalformedURLException exception) {
            throw new JAXRPCException("bad url", (Throwable)exception);
        }
        if (this.serviceQName == null) {
            this.serviceQName = FabricUtil.pickServiceQName(bestService);
        }
        this.endpoint = bestService.getServiceInfo().getEndpointXURL();
        this.baseService = this.fabricService.getParentFactory().getBaseFactory().createService(wsdlLocation, this.serviceQName);
        this.baseProxy = this.portName == null ? this.baseService.getPort(this.serviceEndpointInterface) : this.baseService.getPort(this.portName, this.serviceEndpointInterface);
    }

    private void handleClientException(Throwable exception) throws Throwable {
        Exception serviceException = new Exception();
        NetEvent serviceEvent = new NetEvent(this.endpoint, serviceException);
        NetLog.addEvent(serviceEvent);
        if (!this.shouldRebind(exception)) {
            throw exception;
        }
        this.bind();
    }

    protected boolean shouldRebind(Throwable exception) {
        if (exception instanceof IllegalArgumentException) {
            return false;
        }
        if (exception instanceof IllegalAccessException) {
            return false;
        }
        if (exception instanceof InvocationTargetException) {
            return this.shouldRebind(((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof SecurityException) {
            return false;
        }
        if (exception instanceof RemoteException) {
            return true;
        }
        return true;
    }
}

