/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.logs;

import electric.fabric.IFabricConstants;
import electric.fabric.logs.LogEntry;
import electric.fabric.logs.LogEntryComparator;
import electric.util.sorting.BubbleSort;
import electric.xdb.Action;
import electric.xdb.Data;
import electric.xdb.IXDBConstants;
import electric.xdb.Query;
import electric.xdb.Result;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBServer;
import electric.xml.Element;

public class LogEntryLookup
extends Action
implements IFabricConstants,
IXDBConstants {
    public String category;
    public String endpoint;
    public int max;

    public LogEntryLookup() {
    }

    public LogEntryLookup(String category, String endpoint, int max) {
        this.category = category;
        this.endpoint = endpoint;
        this.max = max;
    }

    public Result perform(IXDBServer server) {
        Element envelope = new Element("Envelope");
        Element body = envelope.addElement("Body");
        Element nodeInfoElement = body.addElement("LogEntry");
        Element propertiesElement = nodeInfoElement.addElement("properties");
        Element valuesElement = propertiesElement.addElement("values");
        if (!this.category.equals("*")) {
            valuesElement.setString("category", this.category);
        }
        if (!this.endpoint.equals("*")) {
            valuesElement.setString("endpoint", this.endpoint);
        }
        Query query = new Query(envelope);
        Data[] matches = null;
        try {
            matches = server.getDataForQuery(query);
        }
        catch (XDBException exception) {
            return new Result(new LogEntry[0]);
        }
        Object[] logEntries = new LogEntry[matches.length];
        int i = 0;
        while (i < matches.length) {
            logEntries[i] = (LogEntry)matches[i].getObject();
            ++i;
        }
        BubbleSort.sort(logEntries, new LogEntryComparator());
        if (logEntries.length > this.max) {
            LogEntry[] newLogEntries = new LogEntry[this.max];
            System.arraycopy(logEntries, 0, newLogEntries, 0, this.max);
            return new Result(newLogEntries);
        }
        return new Result(logEntries);
    }
}

